/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.spec;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.applib.spec.AbstractSpecification;

public class SpecificationAbstractTests {
    private AbstractSpecification<SomeDomainObject> specAbstractSomeDomainObject;

    @Test
    public void shouldSatisfyByDefaultForNull() {
        this.specAbstractSomeDomainObject = new AbstractSpecification<SomeDomainObject>(){

            public String satisfiesSafely(SomeDomainObject obj) {
                return null;
            }
        };
        Assert.assertThat((Object)this.specAbstractSomeDomainObject.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSatisfyForNullIfConfiguredAsSuch() {
        this.specAbstractSomeDomainObject = new AbstractSpecification<SomeDomainObject>(AbstractSpecification.Nullability.ENSURE_NOT_NULL, AbstractSpecification.TypeChecking.IGNORE_INCORRECT_TYPE){

            public String satisfiesSafely(SomeDomainObject obj) {
                return null;
            }
        };
        Assert.assertThat((Object)this.specAbstractSomeDomainObject.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void shouldSatisfyByDefaultForIncorrectType() {
        this.specAbstractSomeDomainObject = new AbstractSpecification<SomeDomainObject>(){

            public String satisfiesSafely(SomeDomainObject obj) {
                return null;
            }
        };
        Assert.assertThat((Object)this.specAbstractSomeDomainObject.satisfies((Object)new SomeOtherDomainObject()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSatisfyForIncorrectTypeIfConfiguredAsSuch() {
        this.specAbstractSomeDomainObject = new AbstractSpecification<SomeDomainObject>(AbstractSpecification.Nullability.IGNORE_IF_NULL, AbstractSpecification.TypeChecking.ENSURE_CORRECT_TYPE){

            public String satisfiesSafely(SomeDomainObject obj) {
                return null;
            }
        };
        Assert.assertThat((Object)this.specAbstractSomeDomainObject.satisfies((Object)new SomeOtherDomainObject()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void shouldSatisfyForNonNullCorrectTypeIfConfiguredAsSuch() {
        this.specAbstractSomeDomainObject = new AbstractSpecification<SomeDomainObject>(AbstractSpecification.Nullability.ENSURE_NOT_NULL, AbstractSpecification.TypeChecking.ENSURE_CORRECT_TYPE){

            public String satisfiesSafely(SomeDomainObject obj) {
                return null;
            }
        };
        Assert.assertThat((Object)this.specAbstractSomeDomainObject.satisfies((Object)new SomeDomainObject()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private static class SomeOtherDomainObject {
        private SomeOtherDomainObject() {
        }
    }

    private static class SomeDomainObject {
        private SomeDomainObject() {
        }
    }
}

