/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.fixtures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.applib.AbstractContainedObject;
import org.nakedobjects.applib.fixtures.CompositeFixture;
import org.nakedobjects.applib.fixtures.FixtureClock;
import org.nakedobjects.applib.fixtures.FixtureType;
import org.nakedobjects.applib.fixtures.InstallableFixture;
import org.nakedobjects.applib.switchuser.SwitchUserService;
import org.nakedobjects.applib.switchuser.SwitchUserServiceAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFixture
extends AbstractContainedObject
implements InstallableFixture,
CompositeFixture,
SwitchUserServiceAware {
    private final List<Object> fixtures = new ArrayList<Object>();
    private FixtureClock clock = null;
    private final FixtureType fixtureType;
    private SwitchUserService switchUserService;

    public AbstractFixture() {
        this(FixtureType.OBJECT_STORE);
    }

    public AbstractFixture(FixtureType fixtureType) {
        this.fixtureType = fixtureType;
        try {
            this.clock = FixtureClock.initialize();
        }
        catch (IllegalStateException ex) {
            this.clock = null;
            System.err.println(ex.getMessage());
            System.err.println("calls to change date or time will be ignored");
        }
    }

    @Override
    public FixtureType getType() {
        return this.fixtureType;
    }

    @Override
    public void install() {
    }

    protected void addFixture(Object fixture) {
        this.fixtures.add(fixture);
    }

    @Override
    public List<Object> getFixtures() {
        return Collections.unmodifiableList(this.fixtures);
    }

    public FixtureClock getFixtureClock() {
        return this.clock;
    }

    public void earlierDate(int years, int months, int days) {
        if (this.clockNotSetup("earlierDate")) {
            return;
        }
        this.clock.addDate(-years, -months, -days);
    }

    public void earlierTime(int hours, int minutes) {
        if (this.clockNotSetup("earlierDate")) {
            return;
        }
        this.clock.addTime(-hours, -minutes);
    }

    public void laterDate(int years, int months, int days) {
        if (this.clockNotSetup("laterDate")) {
            return;
        }
        this.clock.addDate(years, months, days);
    }

    public void laterTime(int hours, int minutes) {
        if (this.clockNotSetup("laterTime")) {
            return;
        }
        this.clock.addTime(hours, minutes);
    }

    public void resetClock() {
        if (this.clockNotSetup("laterTime")) {
            return;
        }
        this.clock.reset();
    }

    public void setDate(int year, int month, int day) {
        if (this.clockNotSetup("setDate")) {
            return;
        }
        this.clock.setDate(year, month, day);
    }

    public void setTime(int hour, int minute) {
        if (this.clockNotSetup("setTime")) {
            return;
        }
        this.clock.setTime(hour, minute);
    }

    private boolean clockNotSetup(String methodName) {
        if (this.clock == null) {
            System.err.println("clock not set, call to " + methodName + " ignored");
            return true;
        }
        return false;
    }

    protected void switchUser(String username, String ... roles) {
        this.switchUserService.switchUser(username, roles);
    }

    @Override
    public void setService(SwitchUserService fixtureService) {
        this.switchUserService = fixtureService;
    }
}

