/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.fixtures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.applib.fixtures.FixtureType;
import org.nakedobjects.applib.fixtures.InstallableFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogonFixture
implements InstallableFixture {
    private final String username;
    private final List<String> roles = new ArrayList<String>();

    private static List<String> asList(String ... roles) {
        return roles != null ? Arrays.asList(roles) : Collections.EMPTY_LIST;
    }

    public LogonFixture(String username, String ... roles) {
        this(username, LogonFixture.asList(roles));
    }

    public LogonFixture(String username, List<String> roles) {
        this.username = username;
        this.roles.addAll(roles);
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    @Override
    public final void install() {
    }

    @Override
    public FixtureType getType() {
        return FixtureType.OTHER;
    }

    public String toString() {
        return "LogonFixture [user: " + this.getUsername() + ", roles: " + this.getRoles() + "]";
    }
}

