/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.nakedobjects.applib.annotation.Value;
import org.nakedobjects.applib.clock.Clock;
import org.nakedobjects.applib.value.Magnitude;

@Value(semanticsProviderName="org.nakedobjects.metamodel.value.DateValueSemanticsProvider")
public class Date
extends Magnitude {
    private static final long serialVersionUID = 1L;
    private static final TimeZone UTC_TIME_ZONE;
    private static final DateFormat MEDIUM_FORMAT;
    private final java.util.Date date;

    public Date() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UTC_TIME_ZONE);
        java.util.Date d = new java.util.Date(Clock.getTime());
        cal.setTime(d);
        this.clearTime(cal);
        this.date = cal.getTime();
    }

    public Date(int year, int month, int day) {
        this.checkDate(year, month, day);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UTC_TIME_ZONE);
        this.clearTime(cal);
        cal.set(year, month - 1, day);
        this.date = cal.getTime();
    }

    public Date(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UTC_TIME_ZONE);
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.date = cal.getTime();
    }

    protected Date createDate(java.util.Date time) {
        return new Date(time);
    }

    public Date add(int years, int months, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UTC_TIME_ZONE);
        cal.setTime(this.date);
        cal.add(5, days);
        cal.add(2, months);
        cal.add(1, years);
        return this.createDate(cal.getTime());
    }

    private void checkDate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be in the range 1 - 12 inclusive");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UTC_TIME_ZONE);
        cal.set(year, month - 1, 0);
        int lastDayOfMonth = cal.getMaximum(5);
        if (day < 1 || day > lastDayOfMonth) {
            throw new IllegalArgumentException("Day must be in the range 1 - " + lastDayOfMonth + " inclusive: " + day);
        }
    }

    private void clearTime(Calendar cal) {
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(9, 0);
        cal.set(14, 0);
    }

    public java.util.Date dateValue() {
        return new java.util.Date(this.date.getTime());
    }

    private int getEndDayOfMonthOneDotOne(Calendar originalCalendar) {
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.setTimeZone(originalCalendar.getTimeZone());
        newCalendar.setTime(originalCalendar.getTime());
        int firstPossibleDay = originalCalendar.getLeastMaximum(5);
        int lastPossibleDay = originalCalendar.getMaximum(5);
        int lastValidDay = firstPossibleDay;
        int day = firstPossibleDay + 1;
        while (day < lastPossibleDay) {
            newCalendar.set(5, day);
            if (newCalendar.get(2) != originalCalendar.get(2)) {
                return lastValidDay;
            }
            lastValidDay = day++;
        }
        return lastPossibleDay;
    }

    private int getEndDayOfMonth(Calendar originalCalendar) {
        Class<?> cls = originalCalendar.getClass();
        try {
            Method getActualMaximum = cls.getMethod("getActualMaximum", Integer.TYPE);
            return (Integer)getActualMaximum.invoke((Object)originalCalendar, new Integer(5));
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.getEndDayOfMonthOneDotOne(originalCalendar);
    }

    public Date endOfMonth() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        c.set(5, this.getEndDayOfMonth(c));
        return this.createDate(c.getTime());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Date) {
            Date d = (Date)obj;
            return d.date.equals(this.date);
        }
        return super.equals(obj);
    }

    public int getDay() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        return c.get(5);
    }

    public int getDayOfWeek() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        int day = c.get(7);
        if (day == 1) {
            return 6;
        }
        return day - 2;
    }

    public int getMonth() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        return c.get(2) + 1;
    }

    public int getYear() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        return c.get(1);
    }

    public boolean isEqualTo(Magnitude date) {
        if (date instanceof Date) {
            return this.date.equals(((Date)date).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public boolean isLessThan(Magnitude date) {
        if (date instanceof Date) {
            return this.date.before(((Date)date).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    private boolean sameAs(Date as, int field) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeZone(UTC_TIME_ZONE);
        c2.setTime(as.date);
        return c.get(field) == c2.get(field);
    }

    public boolean sameDayOfMonthAs(Date as) {
        return this.sameAs(as, 5);
    }

    public boolean sameDayOfWeekAs(Date as) {
        return this.sameAs(as, 7);
    }

    public boolean sameDayOfYearAs(Date as) {
        return this.sameAs(as, 6);
    }

    public boolean sameMonthAs(Date as) {
        return this.sameAs(as, 2);
    }

    public boolean sameWeekAs(Date as) {
        return this.sameAs(as, 3);
    }

    public boolean sameYearAs(Date as) {
        return this.sameAs(as, 1);
    }

    public Date startOfMonth() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        c.set(5, c.getMinimum(5));
        return this.createDate(c.getTime());
    }

    public Date startOfWeek() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        c.set(7, c.getFirstDayOfWeek());
        return this.createDate(c.getTime());
    }

    public Date startOfYear() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC_TIME_ZONE);
        c.setTime(this.date);
        c.set(6, c.getMinimum(6));
        return this.createDate(c.getTime());
    }

    public String title() {
        return MEDIUM_FORMAT.format(this.date);
    }

    public String toString() {
        return this.getYear() + "-" + this.getMonth() + "-" + this.getDay();
    }

    static {
        MEDIUM_FORMAT = DateFormat.getDateInstance(2);
        TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone("UTC");
        }
        UTC_TIME_ZONE = timeZone;
    }
}

