/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.applib.value.Date;
import org.nakedobjects.applib.value.Magnitude;
import org.nakedobjects.applib.value.TestClock;

public class DateTest {
    private Date actual;

    @Before
    public void setUp() throws Exception {
        TestClock.initialize();
        this.actual = new Date(2000, 3, 14);
    }

    @Test
    public void testGetDay() {
        Assert.assertEquals((long)14L, (long)this.actual.getDay());
    }

    @Test
    public void testGetMonth() {
        Assert.assertEquals((long)3L, (long)this.actual.getMonth());
    }

    @Test
    public void testGetYear() {
        Assert.assertEquals((long)2000L, (long)this.actual.getYear());
    }

    @Test
    public void testAdd() {
        Date resultDate = this.actual.add(1, 2, 3);
        Assert.assertEquals((long)17L, (long)resultDate.getDay());
        Assert.assertEquals((long)5L, (long)resultDate.getMonth());
        Assert.assertEquals((long)2001L, (long)resultDate.getYear());
    }

    @Test
    public void testDate() {
        this.actual = new Date(2001, 3, 7);
        Assert.assertEquals((String)"day", (long)7L, (long)this.actual.getDay());
        Assert.assertEquals((String)"month", (long)3L, (long)this.actual.getMonth());
        Assert.assertEquals((String)"year", (long)2001L, (long)this.actual.getYear());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertTrue((boolean)this.actual.equals((Object)this.actual));
        Assert.assertTrue((boolean)new Date(2003, 8, 17).equals((Object)new Date()));
        Assert.assertTrue((boolean)this.actual.equals((Object)new Date(2000, 3, 14)));
    }

    @Test
    public void testIsLestThan() throws Exception {
        Assert.assertFalse((boolean)new Date(2003, 8, 17).isLessThan((Magnitude)new Date(2003, 8, 17)));
        Assert.assertTrue((boolean)new Date(2003, 8, 16).isLessThan((Magnitude)new Date(2003, 8, 17)));
    }

    @Test
    public void testSameDayOfWeekAs() throws Exception {
        Assert.assertTrue((boolean)new Date(2000, 2, 17).sameDayOfWeekAs(new Date(2003, 8, 7)));
        Assert.assertFalse((boolean)new Date(2000, 2, 15).sameDayOfWeekAs(new Date(2003, 8, 17)));
    }

    @Test
    public void testSameDayOfMonthAs() throws Exception {
        Assert.assertTrue((boolean)new Date(2000, 2, 17).sameDayOfMonthAs(new Date(2003, 8, 17)));
        Assert.assertFalse((boolean)new Date(2000, 2, 15).sameDayOfMonthAs(new Date(2003, 8, 17)));
    }

    @Test
    public void testSameDayOfYearAs() throws Exception {
        Assert.assertTrue((boolean)new Date(2001, 8, 17).sameDayOfYearAs(new Date(2003, 8, 17)));
        Assert.assertTrue((boolean)new Date(1999, 3, 1).sameDayOfYearAs(new Date(2000, 2, 29)));
        Assert.assertFalse((boolean)new Date(2001, 3, 1).sameDayOfYearAs(new Date(2000, 3, 2)));
    }

    @Test
    public void testSameWeekAs() throws Exception {
        Assert.assertFalse((boolean)new Date(2000, 2, 15).sameWeekAs(new Date(2000, 2, 12)));
        Assert.assertTrue((boolean)new Date(2001, 2, 16).sameWeekAs(new Date(2002, 2, 11)));
    }

    @Test
    public void testSameMonthAs() throws Exception {
        Assert.assertTrue((boolean)new Date(2000, 8, 15).sameMonthAs(new Date(2003, 8, 17)));
        Assert.assertFalse((boolean)new Date(2003, 2, 17).sameMonthAs(new Date(2003, 8, 17)));
    }

    @Test
    public void testSameYearAs() throws Exception {
        Assert.assertTrue((boolean)new Date(2003, 2, 15).sameYearAs(new Date(2003, 8, 17)));
        Assert.assertFalse((boolean)new Date(2000, 2, 15).sameYearAs(new Date(2003, 8, 17)));
    }

    @Test
    public void testDateValue() {
        Date date = new Date(1970, 1, 1);
        Assert.assertEquals((long)1970L, (long)date.getYear());
        Assert.assertEquals((long)1L, (long)date.getMonth());
        Assert.assertEquals((long)1L, (long)date.getDay());
        long time = date.dateValue().getTime();
        Assert.assertEquals((long)0L, (long)time);
    }

    @Test
    public void testStartOfYear() {
        Assert.assertEquals((Object)new Date(2000, 1, 1), (Object)this.actual.startOfYear());
    }

    @Test
    public void testStartOfMonth() {
        Assert.assertEquals((Object)new Date(2000, 3, 1), (Object)this.actual.startOfMonth());
    }

    @Test
    public void testStartOfWeek() {
        Assert.assertEquals((Object)new Date(2000, 3, 13), (Object)this.actual.startOfWeek());
        Assert.assertEquals((Object)new Date(2000, 2, 28), (Object)new Date(2000, 3, 2).startOfWeek());
    }

    @Test
    public void testNewWithTodaysDate() {
        Date actual = new Date();
        Date expected = new Date(2003, 8, 17);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"2000-3-14", (Object)this.actual.toString());
    }
}

