/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.util;

public class NameUtils {
    private static final char SPACE = ' ';

    public static String naturalName(String name) {
        int length = name.length();
        if (length <= 1) {
            return name.toUpperCase();
        }
        StringBuffer naturalName = new StringBuffer(length);
        char character = Character.toUpperCase(name.charAt(0));
        naturalName.append(character);
        char nextCharacter = name.charAt(1);
        for (int pos = 2; pos < length; ++pos) {
            char previousCharacter = character;
            character = nextCharacter;
            nextCharacter = name.charAt(pos);
            if (previousCharacter != ' ') {
                if (Character.isUpperCase(character) && !Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isUpperCase(character) && Character.isLowerCase(nextCharacter) && Character.isUpperCase(previousCharacter)) {
                    naturalName.append(' ');
                }
                if (Character.isDigit(character) && !Character.isDigit(previousCharacter)) {
                    naturalName.append(' ');
                }
            }
            naturalName.append(character);
        }
        naturalName.append(nextCharacter);
        return naturalName.toString();
    }

    public static String[] naturalNames(String[] names) {
        String[] naturalNames = new String[names.length];
        int i = 0;
        for (String name : names) {
            naturalNames[i++] = NameUtils.naturalName(name);
        }
        return naturalNames;
    }
}

