/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import org.nakedobjects.applib.annotation.Facets;
import org.nakedobjects.applib.value.Magnitude;

@Facets(facetFactoryNames={"org.nakedobjects.metamodel.value.ColorValueTypeFacetFactory"})
public class Color
extends Magnitude {
    private static final long serialVersionUID = 1L;
    public static final Color WHITE = new Color(0xFFFFFF);
    public static final Color BLACK = new Color(0);
    private final int color;

    public Color(int color) {
        this.color = color;
    }

    public int intValue() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Color) {
            Color c = (Color)obj;
            return c.color == this.color;
        }
        return super.equals(obj);
    }

    public boolean isEqualTo(Magnitude number) {
        if (number instanceof Color) {
            return ((Color)number).color == this.color;
        }
        throw new IllegalArgumentException("Parameter must be of type Color");
    }

    public boolean isLessThan(Magnitude value) {
        if (value instanceof Color) {
            return this.color < ((Color)value).color;
        }
        throw new IllegalArgumentException("Parameter must be of type Color");
    }

    public String title() {
        if (this.color == 0) {
            return "Black";
        }
        if (this.color == 0xFFFFFF) {
            return "White";
        }
        return "#" + Integer.toHexString(this.color).toUpperCase();
    }

    public String toString() {
        return "Color: #" + Integer.toHexString(this.color).toUpperCase();
    }
}

