/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.events;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.applib.events.InteractionEvent;

@RunWith(value=JMock.class)
public class InteractionEventTest {
    private final Mockery mockery = new JUnit4Mockery();
    private InteractionEvent interactionEvent;
    private Object source;
    private Identifier identifier;
    private Class<? extends InteractionEventTest> advisorClass;

    @Before
    public void setUp() {
        this.source = new Object();
        this.identifier = Identifier.actionIdentifier((String)"CustomerOrder", (String)"cancelOrder", (Class[])new Class[]{String.class, Boolean.TYPE});
        this.advisorClass = this.getClass();
    }

    @Test
    public void getIdentifier() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        Assert.assertThat((Object)this.interactionEvent.getIdentifier(), (Matcher)CoreMatchers.is((Object)this.identifier));
    }

    @Test
    public void getSource() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        Assert.assertThat((Object)this.interactionEvent.getSource(), (Matcher)CoreMatchers.is((Object)this.source));
    }

    @Test
    public void getClassName() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        Assert.assertThat((Object)this.interactionEvent.getClassName(), (Matcher)CoreMatchers.equalTo((Object)"CustomerOrder"));
    }

    @Test
    public void getClassNaturalName() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        Assert.assertThat((Object)this.interactionEvent.getClassNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Customer Order"));
    }

    @Test
    public void getMember() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        Assert.assertThat((Object)this.interactionEvent.getMemberName(), (Matcher)CoreMatchers.equalTo((Object)"cancelOrder"));
    }

    @Test
    public void getMemberNaturalName() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        Assert.assertThat((Object)this.interactionEvent.getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Cancel Order"));
    }

    @Test
    public void shouldInitiallyNotVeto() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        Assert.assertThat((Object)this.interactionEvent.isVeto(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void afterAdvisedShouldVeto() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        this.interactionEvent.advised("some reason", this.getClass());
        Assert.assertThat((Object)this.interactionEvent.isVeto(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void afterAdvisedShouldReturnReason() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        this.interactionEvent.advised("some reason", this.getClass());
        Assert.assertThat((Object)this.interactionEvent.isVeto(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void afterAdvisedShouldReturnAdvisorClass() {
        this.interactionEvent = new InteractionEvent(this.source, this.identifier){
            private static final long serialVersionUID = 1L;
        };
        this.interactionEvent.advised("some reason", this.advisorClass);
        Assert.assertEquals((Object)this.interactionEvent.getAdvisorClass(), this.advisorClass);
    }
}

