/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.applib.value.Magnitude;
import org.nakedobjects.applib.value.Percentage;

public class PercentageTest {
    Percentage p1;
    Percentage p2;
    Percentage p3;

    @Before
    public void setUp() throws Exception {
        this.p1 = new Percentage(10.5f);
        this.p2 = new Percentage(10.5f);
        this.p3 = new Percentage(12.0f);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)this.p1, (Object)this.p2);
        Assert.assertNotSame((Object)this.p1, (Object)this.p2);
        Assert.assertFalse((boolean)this.p1.equals(this.p3));
    }

    @Test
    public void testAddFloat() {
        Percentage p4 = this.p1.add(10.0f);
        Assert.assertEquals((double)20.5, (double)p4.floatValue(), (double)0.0);
    }

    @Test
    public void testAddPercentage() {
        Percentage p4 = this.p1.add(this.p3);
        Assert.assertEquals((double)22.5, (double)p4.floatValue(), (double)0.0);
    }

    @Test
    public void testIsEqualTo() {
        Assert.assertTrue((boolean)this.p1.isEqualTo((Magnitude)this.p2));
        Assert.assertFalse((boolean)this.p1.isEqualTo((Magnitude)this.p3));
    }

    @Test
    public void testIsLessThan() {
        Assert.assertTrue((boolean)this.p1.isLessThan((Magnitude)this.p3));
        Assert.assertFalse((boolean)this.p3.isLessThan((Magnitude)this.p1));
        Assert.assertFalse((boolean)this.p1.isLessThan((Magnitude)this.p1));
    }
}

