/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.applib.value.Magnitude;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.applib.value.Time;

public class TimeTest {
    private Time time;

    public static void main(String[] args) {
        Date date = new Date(50400000L);
        Locale.setDefault(Locale.KOREA);
        Locale.setDefault(Locale.US);
        Locale.setDefault(Locale.FRANCE);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/London"));
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/Paris"));
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        DateFormat format = DateFormat.getDateTimeInstance();
        System.out.println(date.toString());
        System.out.println(format.format(date));
    }

    @Before
    public void setUp() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/London"));
        TestClock.initialize();
        this.time = new Time(13, 14);
    }

    @Test
    public void testAdd() {
        Time result = this.time.add(2, 3);
        Assert.assertEquals((long)17L, (long)result.getMinute());
        Assert.assertEquals((long)15L, (long)result.getHour());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertTrue((boolean)this.time.equals((Object)this.time));
        Assert.assertTrue((boolean)this.time.equals((Object)new Time(13, 14)));
        Assert.assertTrue((boolean)new Time(13, 14).equals((Object)this.time));
    }

    @Test
    public void testGetHour() {
        Assert.assertEquals((long)13L, (long)this.time.getHour());
    }

    @Test
    public void testGetMinute() {
        Assert.assertEquals((long)14L, (long)this.time.getMinute());
    }

    @Test
    public void testIsLestThan() throws Exception {
        Assert.assertFalse((boolean)new Time(8, 17).isLessThan((Magnitude)new Time(8, 17)));
        Assert.assertTrue((boolean)new Time(8, 16).isLessThan((Magnitude)new Time(8, 17)));
    }

    @Test
    public void testNewWithCurrentTime() {
        Time expected = new Time(21, 30);
        Time actual = new Time();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSameHourAs() throws Exception {
        Assert.assertTrue((boolean)new Time(8, 17).sameHourAs(new Time(8, 7)));
        Assert.assertFalse((boolean)new Time(2, 15).sameHourAs(new Time(8, 17)));
    }

    @Test
    public void testSameMinuteAs() throws Exception {
        Assert.assertTrue((boolean)new Time(2, 17).sameMinuteAs(new Time(8, 17)));
        Assert.assertFalse((boolean)new Time(2, 15).sameMinuteAs(new Time(8, 17)));
    }

    @Test
    public void testStartOfHour() {
        Assert.assertEquals((Object)new Time(13, 0), (Object)this.time.onTheHour());
    }

    @Test
    public void testTitle() {
        Assert.assertEquals((Object)"13:14", (Object)this.time.titleString());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"13:14", (Object)this.time.toString());
    }
}

