/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib;

import org.nakedobjects.applib.util.NameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identifier
implements Comparable<Identifier> {
    public static Depth CLASS = Depth.CLASS;
    public static Depth CLASS_MEMBERNAME = Depth.CLASS_MEMBERNAME;
    public static Depth CLASS_MEMBERNAME_PARMS = Depth.CLASS_MEMBERNAME_PARMS;
    public static Depth MEMBERNAME_ONLY = Depth.MEMBERNAME_ONLY;
    public static Depth PARMS_ONLY = Depth.PARMS_ONLY;
    private final String className;
    private final String memberName;
    private final String[] parameterNames;
    private final Type type;
    private String identityString;
    private String asString = null;

    public static Identifier classIdentifier(Class<?> cls) {
        return Identifier.classIdentifier(cls.getName());
    }

    public static Identifier classIdentifier(String className) {
        return new Identifier(className, "", new String[0], Type.CLASS);
    }

    public static Identifier propertyOrCollectionIdentifier(Class<?> declaringClass, String propertyOrCollectionName) {
        return Identifier.propertyOrCollectionIdentifier(declaringClass.getCanonicalName(), propertyOrCollectionName);
    }

    public static Identifier propertyOrCollectionIdentifier(String declaringClassName, String propertyOrCollectionName) {
        return new Identifier(declaringClassName, propertyOrCollectionName, new String[0], Type.PROPERTY_OR_COLLECTION);
    }

    public static Identifier actionIdentifier(Class<?> declaringClass, String actionName, Class<?>[] parameterClasses) {
        return Identifier.actionIdentifier(declaringClass.getCanonicalName(), actionName, Identifier.toParameterStringArray(parameterClasses));
    }

    public static Identifier actionIdentifier(String declaringClassName, String actionName, Class<?>[] parameterClasses) {
        return Identifier.actionIdentifier(declaringClassName, actionName, Identifier.toParameterStringArray(parameterClasses));
    }

    public static Identifier actionIdentifier(String declaringClassName, String actionName, String[] parameterClassNames) {
        return new Identifier(declaringClassName, actionName, parameterClassNames, Type.ACTION);
    }

    private static String[] toParameterStringArray(Class<?>[] parameterClasses) {
        String[] parameters = new String[parameterClasses == null ? 0 : parameterClasses.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = parameterClasses[i].getName();
        }
        return parameters;
    }

    private Identifier(String className, String memberName, String[] parameterNames, Type type) {
        this.className = className;
        this.memberName = memberName;
        this.parameterNames = parameterNames;
        this.type = type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberNaturalName() {
        return NameUtils.naturalName(this.memberName);
    }

    public String[] getMemberParameterNames() {
        return this.parameterNames;
    }

    public String[] getMemberParameterNaturalNames() {
        return NameUtils.naturalNames(this.parameterNames);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPropertyOrCollection() {
        return this.type == Type.PROPERTY_OR_COLLECTION;
    }

    public String toIdentityString(Depth depth) {
        return depth.toIdentityString(this);
    }

    public String toClassIdentityString() {
        return this.toClassIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toClassIdentityString(StringBuilder buf) {
        return buf.append(this.className);
    }

    public String toNameIdentityString() {
        return this.toNameIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toNameIdentityString(StringBuilder buf) {
        return buf.append(this.memberName);
    }

    public String toClassAndNameIdentityString() {
        return this.toClassAndNameIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toClassAndNameIdentityString(StringBuilder buf) {
        return this.toClassIdentityString(buf).append("#").append(this.memberName);
    }

    public String toParmsIdentityString() {
        return this.toParmsIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toParmsIdentityString(StringBuilder buf) {
        if (this.type == Type.ACTION) {
            buf.append('(');
            for (int i = 0; i < this.parameterNames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.parameterNames[i]);
            }
            buf.append(')');
        }
        return buf;
    }

    public String toNameParmsIdentityString() {
        return this.getMemberName() + this.toParmsIdentityString();
    }

    public StringBuilder toNameParmsIdentityString(StringBuilder buf) {
        buf.append(this.getMemberName());
        this.toParmsIdentityString(buf);
        return buf;
    }

    public String toFullIdentityString() {
        if (this.identityString == null) {
            if (this.memberName.length() == 0) {
                this.identityString = this.toClassIdentityString();
            } else {
                StringBuilder buf = new StringBuilder();
                this.toClassAndNameIdentityString(buf);
                this.toParmsIdentityString(buf);
                this.identityString = buf.toString();
            }
        }
        return this.identityString;
    }

    @Override
    public int compareTo(Identifier o2) {
        return this.toString().compareTo(o2.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return this.equals(other);
    }

    public boolean equals(Identifier other) {
        return this.equals(other.className, this.className) && this.equals(other.memberName, other.memberName) && this.equals(other.parameterNames, this.parameterNames);
    }

    private boolean equals(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    private boolean equals(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.asString == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.className);
            buf.append('#');
            buf.append(this.memberName);
            buf.append('(');
            for (int i = 0; i < this.parameterNames.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.parameterNames[i]);
            }
            buf.append(')');
            this.asString = buf.toString();
        }
        return this.asString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Depth {
        CLASS{

            public String toIdentityString(Identifier identifier) {
                return identifier.toClassIdentityString();
            }
        }
        ,
        CLASS_MEMBERNAME{

            public String toIdentityString(Identifier identifier) {
                return identifier.toClassAndNameIdentityString();
            }
        }
        ,
        CLASS_MEMBERNAME_PARMS{

            public String toIdentityString(Identifier identifier) {
                return identifier.toFullIdentityString();
            }
        }
        ,
        MEMBERNAME_ONLY{

            public String toIdentityString(Identifier identifier) {
                return identifier.toNameIdentityString();
            }
        }
        ,
        PARMS_ONLY{

            public String toIdentityString(Identifier identifier) {
                return identifier.toParmsIdentityString();
            }
        };


        public abstract String toIdentityString(Identifier var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CLASS,
        PROPERTY_OR_COLLECTION,
        ACTION;

    }
}

