/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.applib.value;

import java.util.Calendar;
import java.util.Date;
import org.nakedobjects.applib.annotation.Value;
import org.nakedobjects.applib.clock.Clock;
import org.nakedobjects.applib.value.Magnitude;

@Value(semanticsProviderName="org.nakedobjects.metamodel.value.DateTimeValueSemanticsProvider")
public class DateTime
extends Magnitude {
    private static final long serialVersionUID = 1L;
    private final Date date;

    public DateTime() {
        Calendar cal = Calendar.getInstance();
        Date d = new Date(Clock.getTime());
        cal.setTime(d);
        cal.set(14, 0);
        this.date = cal.getTime();
    }

    public DateTime(Date date) {
        this.date = date;
    }

    public DateTime(int year, int month, int day) {
        this(year, month, day, 0, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute) {
        this(year, month, day, hour, minute, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this.checkTime(year, month, day, hour, minute);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, 0);
        this.date = cal.getTime();
    }

    private void checkTime(int year, int month, int day, int hour, int minute) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be in the range 1 - 12 inclusive " + month);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, 0);
        int lastDayOfMonth = cal.getMaximum(5);
        if (day < 1 || day > lastDayOfMonth) {
            throw new IllegalArgumentException("Day must be in the range 1 - " + lastDayOfMonth + " inclusive " + day);
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be in the range 0 - 23 inclusive " + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be in the range 0 - 59 inclusive " + minute);
        }
    }

    public DateTime add(int years, int months, int days, int hours, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(12, minutes);
        cal.add(11, hours);
        cal.add(5, days);
        cal.add(2, months);
        cal.add(1, years);
        return this.createDateTime(cal.getTime());
    }

    public Calendar calendarValue() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c;
    }

    protected DateTime createDateTime(Date date) {
        return new DateTime(date);
    }

    public Date dateValue() {
        return new Date(this.date.getTime());
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateTime) {
            DateTime d = (DateTime)obj;
            return d.date.equals(this.date);
        }
        return super.equals(obj);
    }

    public int getDay() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(5);
    }

    public int getHour() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(11);
    }

    public int getMinute() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(12);
    }

    public int getMonth() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(2) + 1;
    }

    public int getYear() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        return c.get(1);
    }

    public boolean isEqualTo(Magnitude timeStamp) {
        if (timeStamp instanceof DateTime) {
            return this.date.equals(((DateTime)timeStamp).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public boolean isLessThan(Magnitude timeStamp) {
        if (timeStamp instanceof DateTime) {
            return this.date.before(((DateTime)timeStamp).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public long longValue() {
        return this.date.getTime();
    }

    public String toString() {
        return this.longValue() + " [DateTime]";
    }
}

