/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.bytecode.javassist.persistence.objectfactory.internal;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.bytecode.javassist.persistence.objectfactory.internal.JavassistEnhanced;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.spec.JavaSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.persistence.objectfactory.MethodUtils;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectChanger;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectResolveAndObjectChangedEnhancer {
    private final ObjectResolver objectResolver;
    private final ObjectChanger objectChanger;
    private final SpecificationLoader specificationLoader;
    private MethodHandler methodHandler;

    public ObjectResolveAndObjectChangedEnhancer(final ObjectResolver objectResolver, final ObjectChanger objectChanger, SpecificationLoader specificationLoader) {
        Ensure.ensureThatArg((Object)objectResolver, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)objectChanger, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.objectResolver = objectResolver;
        this.objectChanger = objectChanger;
        this.specificationLoader = specificationLoader;
        this.methodHandler = new MethodHandler(){

            public Object invoke(Object proxied, Method proxyMethod, Method proxiedMethod, Object[] args) throws Throwable {
                boolean isSetter;
                boolean ignore = proxyMethod.getDeclaringClass().equals(Object.class);
                JavaSpecification targetObjSpec = ObjectResolveAndObjectChangedEnhancer.this.getJavaSpecificationOfOwningClass(proxiedMethod);
                NakedObjectMember member = targetObjSpec.getMember(proxiedMethod);
                boolean isAssociation = member != null && member.isAssociation();
                boolean isAction = member != null && member.isAction();
                boolean isGetter = isAssociation && MethodUtils.isGetter((Method)proxiedMethod);
                boolean bl = isSetter = isAssociation && MethodUtils.isSetter((Method)proxiedMethod);
                if (!ignore && (isGetter || isSetter)) {
                    objectResolver.resolve(proxied, member.getName());
                }
                Object proxiedReturn = proxiedMethod.invoke(proxied, args);
                if (!ignore && (isSetter || isAction)) {
                    objectChanger.objectChanged(proxied);
                }
                return proxiedReturn;
            }
        };
    }

    public <T> T newInstance(Class<T> cls) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(cls);
        proxyFactory.setInterfaces((Class[])ArrayUtils.combine((Object[][])new Class[][]{cls.getInterfaces(), {JavassistEnhanced.class}}));
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize");
            }
        });
        Class proxySubclass = proxyFactory.createClass();
        try {
            Object newInstance = proxySubclass.newInstance();
            ProxyObject proxyObject = (ProxyObject)newInstance;
            proxyObject.setHandler(this.methodHandler);
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new NakedObjectException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    private JavaSpecification getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private JavaSpecification getJavaSpecification(Class<?> clazz) {
        NakedObjectSpecification nos = this.getSpecification(clazz);
        if (!(nos instanceof JavaSpecification)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + nos.getClass().getCanonicalName() + "')");
        }
        return (JavaSpecification)nos;
    }

    private NakedObjectSpecification getSpecification(Class<?> type) {
        NakedObjectSpecification nos = this.specificationLoader.loadSpecification(type);
        return nos;
    }

    public final ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public final ObjectChanger getObjectChanger() {
        return this.objectChanger;
    }

    public final SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }
}

