/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.nakedobjects.remoting.NakedObjectsRemoteException;
import org.nakedobjects.remoting.client.ClientConnection;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.exchange.ResponseEnvelope;
import org.nakedobjects.remoting.protocol.ClientMarshaller;
import org.nakedobjects.remoting.transport.ConnectionException;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

public class ClientConnectionDefault
implements ClientConnection {
    private static final Logger LOG = Logger.getLogger(ClientConnectionDefault.class);
    private final ClientMarshaller marshaller;

    public ClientConnectionDefault(ClientMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    protected ClientMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void init() {
        this.marshaller.init();
    }

    public void shutdown() {
        this.marshaller.shutdown();
    }

    private void connect() {
        try {
            this.marshaller.connect();
        }
        catch (IOException e) {
            throw new ConnectionException("Connection failure", e);
        }
    }

    private void disconnect() {
        this.marshaller.disconnect();
    }

    public ResponseEnvelope executeRemotely(Request request) {
        this.connect();
        try {
            ResponseEnvelope responseEnvelope = this.executeRemotelyElseException(request);
            return responseEnvelope;
        }
        catch (IOException e) {
            throw new ConnectionException("Failed request", e);
        }
        finally {
            this.disconnect();
        }
    }

    private ResponseEnvelope executeRemotelyElseException(Request request) throws IOException {
        Object response = this.marshaller.request(request);
        if (response instanceof ConcurrencyException) {
            throw (ConcurrencyException)response;
        }
        if (response instanceof Exception) {
            throw new NakedObjectsRemoteException("Exception occurred on server", (Throwable)response);
        }
        return (ResponseEnvelope)response;
    }
}

