/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.authentication;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.StringUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.exchange.OpenSessionRequest;
import org.nakedobjects.remoting.exchange.OpenSessionResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.authentication.standard.PasswordRequestAuthenticatorAbstract;

public final class ProxyAuthenticator
extends PasswordRequestAuthenticatorAbstract {
    private final ServerFacade serverFacade;
    private final ObjectEncoderDecoder encoderDecoder;

    public ProxyAuthenticator(NakedObjectConfiguration configuration, ServerFacade serverFacade, ObjectEncoderDecoder encoderDecoder) {
        super(configuration);
        Ensure.ensureThatArg((Object)serverFacade, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)encoderDecoder, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.serverFacade = serverFacade;
        this.encoderDecoder = encoderDecoder;
    }

    public boolean isValid(AuthenticationRequest request) {
        return this.authenticate(request, null) != null;
    }

    public AuthenticationSession authenticate(AuthenticationRequest authRequest, String code) {
        AuthenticationRequestPassword passwordRequest = (AuthenticationRequestPassword)authRequest;
        String username = passwordRequest.getName();
        if (StringUtils.isEmpty((String)username)) {
            return null;
        }
        String password = passwordRequest.getPassword();
        OpenSessionRequest request = new OpenSessionRequest(username, password);
        OpenSessionResponse response = this.serverFacade.openSession(request);
        return response.getSession();
    }
}

