/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.authorization;

import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.exchange.AuthorizationRequestUsability;
import org.nakedobjects.remoting.exchange.AuthorizationRequestVisibility;
import org.nakedobjects.remoting.exchange.AuthorizationResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.authorization.AuthorizationManagerAbstract;

public class AuthorizationManagerProxy
extends AuthorizationManagerAbstract {
    private final Map<String, Boolean> visibilityCache = new HashMap<String, Boolean>();
    private final Map<String, Boolean> usabilityCache = new HashMap<String, Boolean>();
    private final ServerFacade serverFacade;
    private final ObjectEncoderDecoder encoderDecoder;

    public AuthorizationManagerProxy(NakedObjectConfiguration configuration, ServerFacade serverFacade, ObjectEncoderDecoder encoderDecoder) {
        super(configuration);
        this.serverFacade = serverFacade;
        this.encoderDecoder = encoderDecoder;
    }

    public void init() {
    }

    public void shutdown() {
    }

    public boolean isUsable(AuthenticationSession session, NakedObject target, Identifier identifier) {
        IdentityData targetData = this.encoderDecoder.encodeIdentityData(target);
        String idString = identifier.toIdentityString(Identifier.CLASS_MEMBERNAME_PARMS);
        if (!this.usabilityCache.containsKey(idString)) {
            AuthorizationResponse response = this.serverFacade.authorizeUsability(new AuthorizationRequestUsability(session, targetData, idString));
            Boolean authorized = this.isAuthorized(response);
            this.usabilityCache.put(idString, authorized);
        }
        return this.usabilityCache.get(idString);
    }

    public boolean isVisible(AuthenticationSession session, NakedObject target, Identifier identifier) {
        IdentityData targetData = this.encoderDecoder.encodeIdentityData(target);
        String idString = identifier.toIdentityString(Identifier.CLASS_MEMBERNAME_PARMS);
        if (!this.visibilityCache.containsKey(idString)) {
            AuthorizationRequestVisibility request = new AuthorizationRequestVisibility(session, targetData, idString);
            AuthorizationResponse response = this.serverFacade.authorizeVisibility(request);
            Boolean authorized = this.isAuthorized(response);
            this.visibilityCache.put(idString, authorized);
        }
        return this.visibilityCache.get(idString);
    }

    private Boolean isAuthorized(AuthorizationResponse response) {
        return response != null ? response.isAuthorized() : false;
    }
}

