/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.facets;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacetAbstract;
import org.nakedobjects.remoting.client.facets.ProxyUtil;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.exchange.SetAssociationRequest;
import org.nakedobjects.remoting.exchange.SetAssociationResponse;
import org.nakedobjects.remoting.exchange.SetValueRequest;
import org.nakedobjects.remoting.exchange.SetValueResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertySetterFacetWrapProxy
extends PropertySetterFacetAbstract
implements DecoratingFacet<PropertySetterFacet> {
    private final ServerFacade serverFacade;
    private final ObjectEncoderDecoder encoder;
    private final PropertySetterFacet underlyingFacet;
    private final String name;

    public PropertySetterFacetWrapProxy(PropertySetterFacet underlyingFacet, ServerFacade distribution, ObjectEncoderDecoder encoder, String name) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.serverFacade = distribution;
        this.encoder = encoder;
        this.name = name;
    }

    public PropertySetterFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public void setProperty(NakedObject targetAdapter, NakedObject associateAdapter) {
        if (targetAdapter.isPersistent()) {
            ObjectData[] updates;
            IdentityData targetReference = this.encoder.encodeIdentityData(targetAdapter);
            try {
                if (associateAdapter.getSpecification().isObject()) {
                    IdentityData associateReference = this.encoder.encodeIdentityData(associateAdapter);
                    SetAssociationRequest request = new SetAssociationRequest(PropertySetterFacetWrapProxy.getAuthenticationSession(), this.name, targetReference, associateReference);
                    SetAssociationResponse response = this.serverFacade.setAssociation(request);
                    updates = response.getUpdates();
                } else {
                    EncodableObjectData val = associateAdapter == null ? null : this.encoder.encodeAsValue(associateAdapter);
                    SetValueRequest request = new SetValueRequest(PropertySetterFacetWrapProxy.getAuthenticationSession(), this.name, targetReference, val);
                    SetValueResponse response = this.serverFacade.setValue(request);
                    updates = response.getUpdates();
                }
            }
            catch (ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            }
            this.encoder.decode(updates);
        } else {
            this.underlyingFacet.setProperty(targetAdapter, associateAdapter);
        }
    }

    private static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

