/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.data.common;

import java.io.IOException;
import java.io.Serializable;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.data.common.CollectionData;
import org.nakedobjects.remoting.data.common.ReferenceData;

public class CollectionDataImpl
implements CollectionData,
Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ReferenceData[] elements;
    private final Oid oid;
    private final String collectionType;
    private final Version version;
    private final boolean hasAllElements;
    private final String elementType;

    public CollectionDataImpl(Oid oid, String collectionType, String elementType, ReferenceData[] elements, boolean hasAllElements, Version version) {
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.oid = oid;
        this.version = version;
        this.hasAllElements = hasAllElements;
        this.elements = elements;
        this.initialized();
    }

    public CollectionDataImpl(DataInputExtended input) throws IOException {
        this.collectionType = input.readUTF();
        this.elementType = input.readUTF();
        this.oid = (Oid)input.readEncodable(Oid.class);
        this.version = (Version)input.readEncodable(Version.class);
        this.hasAllElements = input.readBoolean();
        this.elements = (ReferenceData[])input.readEncodables(ReferenceData.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.collectionType);
        output.writeUTF(this.elementType);
        output.writeEncodable((Object)this.oid);
        output.writeEncodable((Object)this.version);
        output.writeBoolean(this.hasAllElements);
        output.writeEncodables((Object[])this.elements);
    }

    private void initialized() {
    }

    public ReferenceData[] getElements() {
        return this.elements;
    }

    public String getElementype() {
        return this.elementType;
    }

    public Oid getOid() {
        return this.oid;
    }

    public String getType() {
        return this.collectionType;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean hasAllElements() {
        return this.hasAllElements;
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("collection type", this.collectionType);
        str.append("element type", this.elementType);
        str.append("oid", (Object)this.oid);
        str.append("version", (Object)this.version);
        str.append(",elements=");
        for (int i = 0; this.elements != null && i < this.elements.length; ++i) {
            if (i > 0) {
                str.append(";");
            }
            if (this.elements[i] == null) {
                str.append("null");
                continue;
            }
            String name = this.elements[i].getClass().getName();
            str.append(name.substring(name.lastIndexOf(46) + 1));
        }
        return str.toString();
    }
}

