/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.exchange.ClearAssociationResponse;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.facade.ServerFacade;

public class ClearAssociationRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String fieldIdentifier;
    private final IdentityData target;
    private final IdentityData associate;

    public ClearAssociationRequest(AuthenticationSession session, String fieldIdentifier, IdentityData target, IdentityData associate) {
        super(session);
        this.fieldIdentifier = fieldIdentifier;
        this.target = target;
        this.associate = associate;
        this.initialized();
    }

    public ClearAssociationRequest(DataInputExtended input) throws IOException {
        super(input);
        this.fieldIdentifier = input.readUTF();
        this.target = (IdentityData)input.readEncodable(IdentityData.class);
        this.associate = (IdentityData)input.readEncodable(IdentityData.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeUTF(this.fieldIdentifier);
        output.writeEncodable((Object)this.target);
        output.writeEncodable((Object)this.associate);
    }

    private void initialized() {
    }

    public String getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public IdentityData getTarget() {
        return this.target;
    }

    public IdentityData getAssociate() {
        return this.associate;
    }

    public void execute(ServerFacade serverFacade) {
        ClearAssociationResponse response = serverFacade.clearAssociation(this);
        this.setResponse(response);
    }

    public ClearAssociationResponse getResponse() {
        return (ClearAssociationResponse)super.getResponse();
    }
}

