/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.exchange.ClearValueResponse;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.facade.ServerFacade;

public class ClearValueRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String fieldIdentifier;
    private final IdentityData target;

    public ClearValueRequest(AuthenticationSession session, String fieldIdentifier, IdentityData target) {
        super(session);
        this.fieldIdentifier = fieldIdentifier;
        this.target = target;
        this.initialized();
    }

    public ClearValueRequest(DataInputExtended input) throws IOException {
        super(input);
        this.fieldIdentifier = input.readUTF();
        this.target = (IdentityData)input.readEncodable(IdentityData.class);
        this.initialized();
    }

    public void encode(DataOutputExtended outputStream) throws IOException {
        super.encode(outputStream);
        outputStream.writeUTF(this.fieldIdentifier);
        outputStream.writeEncodable((Object)this.target);
    }

    private void initialized() {
    }

    public String getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public IdentityData getTarget() {
        return this.target;
    }

    public void execute(ServerFacade serverFacade) {
        ClearValueResponse response = serverFacade.clearValue(this);
        this.setResponse(response);
    }

    public ClearValueResponse getResponse() {
        return (ClearValueResponse)super.getResponse();
    }
}

