/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.exchange.ExecuteServerActionResponse;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.facade.ServerFacade;

public class ExecuteServerActionRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final NakedObjectActionType actionType;
    private final String actionIdentifier;
    private final ReferenceData target;
    private final Data[] parameters;

    public ExecuteServerActionRequest(AuthenticationSession session, NakedObjectActionType actionType, String actionIdentifier, ReferenceData target, Data[] parameters) {
        super(session);
        this.actionType = actionType;
        this.actionIdentifier = actionIdentifier;
        this.target = target;
        this.parameters = parameters;
        this.initialized();
    }

    public ExecuteServerActionRequest(DataInputExtended input) throws IOException {
        super(input);
        this.actionType = NakedObjectActionType.valueOf((String)input.readUTF());
        this.actionIdentifier = input.readUTF();
        this.target = (ReferenceData)input.readEncodable(IdentityData.class);
        this.parameters = (Data[])input.readEncodables(Data.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeUTF(this.actionType.name());
        output.writeUTF(this.actionIdentifier);
        output.writeEncodable((Object)this.target);
        output.writeEncodables((Object[])this.parameters);
    }

    private void initialized() {
    }

    public NakedObjectActionType getActionType() {
        return this.actionType;
    }

    public String getActionIdentifier() {
        return this.actionIdentifier;
    }

    public ReferenceData getTarget() {
        return this.target;
    }

    public Data[] getParameters() {
        return this.parameters;
    }

    public void execute(ServerFacade serverFacade) {
        ExecuteServerActionResponse response = serverFacade.executeServerAction(this);
        this.setResponse(response);
    }

    public ExecuteServerActionResponse getResponse() {
        return (ExecuteServerActionResponse)super.getResponse();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("method", this.actionIdentifier);
        str.append("target", (Object)this.target);
        return str.toString();
    }
}

