/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.data.query.PersistenceQueryData;
import org.nakedobjects.remoting.exchange.FindInstancesResponse;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.facade.ServerFacade;

public class FindInstancesRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final PersistenceQueryData criteria;

    public FindInstancesRequest(AuthenticationSession session, PersistenceQueryData criteria) {
        super(session);
        this.criteria = criteria;
        this.initialized();
    }

    public FindInstancesRequest(DataInputExtended input) throws IOException {
        super(input);
        this.criteria = (PersistenceQueryData)input.readEncodable(PersistenceQueryData.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeEncodable((Object)this.criteria);
    }

    private void initialized() {
    }

    public PersistenceQueryData getCriteria() {
        return this.criteria;
    }

    public void execute(ServerFacade serverFacade) {
        FindInstancesResponse response = serverFacade.findInstances(this);
        this.setResponse(response);
    }

    public FindInstancesResponse getResponse() {
        return (FindInstancesResponse)super.getResponse();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("criteria", (Object)this.criteria);
        return str.toString();
    }
}

