/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.exchange.ResolveFieldResponse;
import org.nakedobjects.remoting.facade.ServerFacade;

public class ResolveFieldRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final IdentityData target;
    private final String fieldIdentifier;

    public ResolveFieldRequest(AuthenticationSession session, IdentityData targetData, String field) {
        super(session);
        this.target = targetData;
        this.fieldIdentifier = field;
        this.initialized();
    }

    public ResolveFieldRequest(DataInputExtended input) throws IOException {
        super(input);
        this.fieldIdentifier = input.readUTF();
        this.target = (IdentityData)input.readEncodable(IdentityData.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeUTF(this.fieldIdentifier);
        output.writeEncodable((Object)this.target);
    }

    private void initialized() {
    }

    public String getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public IdentityData getTarget() {
        return this.target;
    }

    public void execute(ServerFacade serverFacade) {
        ResolveFieldResponse response = serverFacade.resolveField(this);
        this.setResponse(response);
    }

    public ResolveFieldResponse getResponse() {
        return (ResolveFieldResponse)super.getResponse();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("target", (Object)this.target);
        str.append("field", this.fieldIdentifier);
        return str.toString();
    }
}

