/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.exchange.SetValueResponse;
import org.nakedobjects.remoting.facade.ServerFacade;

public class SetValueRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String fieldIdentifier;
    private final EncodableObjectData value;
    private final IdentityData target;

    public SetValueRequest(AuthenticationSession session, String fieldIdentifier, IdentityData target, EncodableObjectData value) {
        super(session);
        this.fieldIdentifier = fieldIdentifier;
        this.target = target;
        this.value = value;
        this.initialized();
    }

    public SetValueRequest(DataInputExtended input) throws IOException {
        super(input);
        this.fieldIdentifier = input.readUTF();
        this.target = (IdentityData)input.readEncodable(IdentityData.class);
        this.value = (EncodableObjectData)input.readEncodable(EncodableObjectData.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeUTF(this.fieldIdentifier);
        output.writeEncodable((Object)this.target);
        output.writeEncodable((Object)this.value);
    }

    private void initialized() {
    }

    public String getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public IdentityData getTarget() {
        return this.target;
    }

    public EncodableObjectData getValue() {
        return this.value;
    }

    public void execute(ServerFacade serverFacade) {
        SetValueResponse response = serverFacade.setValue(this);
        this.setResponse(response);
    }

    public SetValueResponse getResponse() {
        return (SetValueResponse)super.getResponse();
    }
}

