/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.facade.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.spec.identifier.IdentifierFactory;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionImpl;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.remoting.NakedObjectsRemoteException;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.NullData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.data.query.PersistenceQueryData;
import org.nakedobjects.remoting.exchange.AuthorizationRequestUsability;
import org.nakedobjects.remoting.exchange.AuthorizationRequestVisibility;
import org.nakedobjects.remoting.exchange.AuthorizationResponse;
import org.nakedobjects.remoting.exchange.ClearAssociationRequest;
import org.nakedobjects.remoting.exchange.ClearAssociationResponse;
import org.nakedobjects.remoting.exchange.ClearValueRequest;
import org.nakedobjects.remoting.exchange.ClearValueResponse;
import org.nakedobjects.remoting.exchange.CloseSessionRequest;
import org.nakedobjects.remoting.exchange.CloseSessionResponse;
import org.nakedobjects.remoting.exchange.ExecuteClientActionRequest;
import org.nakedobjects.remoting.exchange.ExecuteClientActionResponse;
import org.nakedobjects.remoting.exchange.ExecuteServerActionRequest;
import org.nakedobjects.remoting.exchange.ExecuteServerActionResponse;
import org.nakedobjects.remoting.exchange.FindInstancesRequest;
import org.nakedobjects.remoting.exchange.FindInstancesResponse;
import org.nakedobjects.remoting.exchange.GetObjectRequest;
import org.nakedobjects.remoting.exchange.GetObjectResponse;
import org.nakedobjects.remoting.exchange.GetPropertiesRequest;
import org.nakedobjects.remoting.exchange.GetPropertiesResponse;
import org.nakedobjects.remoting.exchange.HasInstancesRequest;
import org.nakedobjects.remoting.exchange.HasInstancesResponse;
import org.nakedobjects.remoting.exchange.KnownObjectsRequest;
import org.nakedobjects.remoting.exchange.OidForServiceRequest;
import org.nakedobjects.remoting.exchange.OidForServiceResponse;
import org.nakedobjects.remoting.exchange.OpenSessionRequest;
import org.nakedobjects.remoting.exchange.OpenSessionResponse;
import org.nakedobjects.remoting.exchange.ResolveFieldRequest;
import org.nakedobjects.remoting.exchange.ResolveFieldResponse;
import org.nakedobjects.remoting.exchange.ResolveObjectRequest;
import org.nakedobjects.remoting.exchange.ResolveObjectResponse;
import org.nakedobjects.remoting.exchange.SetAssociationRequest;
import org.nakedobjects.remoting.exchange.SetAssociationResponse;
import org.nakedobjects.remoting.exchange.SetValueRequest;
import org.nakedobjects.remoting.exchange.SetValueResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class ServerFacadeImpl
implements ServerFacade {
    private static final Logger LOG = Logger.getLogger(ServerFacadeImpl.class);
    private final AuthenticationManager authenticationManager;
    private ObjectEncoderDecoder encoderDecoder;

    public ServerFacadeImpl(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void init() {
    }

    public void shutdown() {
    }

    public OpenSessionResponse openSession(OpenSessionRequest request2) {
        AuthenticationRequestPassword request = new AuthenticationRequestPassword(request2.getUsername(), request2.getPassword());
        AuthenticationSession session = this.authenticationManager.authenticate((AuthenticationRequest)request);
        return new OpenSessionResponse(session);
    }

    public CloseSessionResponse closeSession(CloseSessionRequest request) {
        this.authenticationManager.closeSession(request.getSession());
        return new CloseSessionResponse();
    }

    public AuthorizationResponse authorizeVisibility(AuthorizationRequestVisibility request) {
        NakedObject targetAdapter = this.encoderDecoder.decode(request.getTarget());
        boolean allowed = this.getMember(request.getIdentifier()).isVisible(request.getSession(), targetAdapter).isAllowed();
        return this.encoderDecoder.encodeAuthorizeResponse(allowed);
    }

    public AuthorizationResponse authorizeUsability(AuthorizationRequestUsability request) {
        NakedObject targetAdapter = this.encoderDecoder.decode(request.getTarget());
        boolean allowed = this.getMember(request.getIdentifier()).isUsable(request.getSession(), targetAdapter).isAllowed();
        return this.encoderDecoder.encodeAuthorizeResponse(allowed);
    }

    private NakedObjectMember getMember(String memberName) {
        Identifier id = IdentifierFactory.fromIdentityString((String)memberName);
        NakedObjectSpecification specification = ServerFacadeImpl.getSpecificationLoader().loadSpecification(id.getClassName());
        if (id.isPropertyOrCollection()) {
            return this.getAssociationElseThrowException(id, specification);
        }
        return this.getActionElseThrowException(id, specification);
    }

    private NakedObjectMember getActionElseThrowException(Identifier id, NakedObjectSpecification specification) {
        NakedObjectAction member = specification.getObjectAction(NakedObjectActionConstants.USER, id.getMemberName(), this.getMemberParameterSpecifications(id));
        if (member == null) {
            throw new NakedObjectException("No user action found for id " + id);
        }
        return member;
    }

    private NakedObjectMember getAssociationElseThrowException(Identifier id, NakedObjectSpecification specification) {
        NakedObjectAssociation member = specification.getAssociation(id.getMemberName());
        if (member == null) {
            throw new NakedObjectException("No property or collection found for id " + id);
        }
        return member;
    }

    private NakedObjectSpecification[] getMemberParameterSpecifications(Identifier id) {
        String[] parameters = id.getMemberParameterNames();
        NakedObjectSpecification[] specifications = new NakedObjectSpecification[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            specifications[i] = ServerFacadeImpl.getSpecificationLoader().loadSpecification(parameters[i]);
        }
        return specifications;
    }

    public GetPropertiesResponse getProperties(GetPropertiesRequest request) {
        Properties properties = new Properties();
        properties.put("test-client", "true");
        NakedObjectConfiguration configuration = NakedObjectsContext.getConfiguration();
        NakedObjectConfiguration serviceProperties = configuration.getProperties("nakedobjects.services");
        Enumeration e = serviceProperties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            properties.put(name, serviceProperties.getString(name));
        }
        String oidGeneratorClass = ServerFacadeImpl.getPersistenceSession().getOidGenerator().getClass().getName();
        if (oidGeneratorClass != null) {
            properties.put("nakedobjects.persistor.oid-generator", oidGeneratorClass);
        }
        return new GetPropertiesResponse(properties);
    }

    public SetAssociationResponse setAssociation(SetAssociationRequest request) {
        AuthenticationSession session = request.getSession();
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData targetData = request.getTarget();
        IdentityData associateData = request.getAssociate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request setAssociation " + fieldIdentifier + " on " + targetData + " with " + associateData + " for " + session));
        }
        NakedObject targetAdapter = this.getPersistentNakedObject(session, targetData);
        NakedObject associate = this.getPersistentNakedObject(session, associateData);
        NakedObjectAssociation association = targetAdapter.getSpecification().getAssociation(fieldIdentifier);
        this.ensureAssociationModifiableElseThrowException(session, targetAdapter, association);
        if (association instanceof OneToOneAssociation) {
            ((OneToOneAssociation)association).setAssociation(targetAdapter, associate);
        } else {
            ((OneToManyAssociation)association).addElement(targetAdapter, associate);
        }
        return new SetAssociationResponse(this.getUpdates());
    }

    public SetValueResponse setValue(SetValueRequest request) {
        AuthenticationSession session = request.getSession();
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData targetIdentityData = request.getTarget();
        EncodableObjectData encodeableObjectData = request.getValue();
        Assert.assertNotNull((Object)encodeableObjectData);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request setValue " + fieldIdentifier + " on " + targetIdentityData + " with " + encodeableObjectData + " for " + session));
        }
        NakedObject targetAdapter = this.getPersistentNakedObject(session, targetIdentityData);
        OneToOneAssociation association = (OneToOneAssociation)targetAdapter.getSpecification().getAssociation(fieldIdentifier);
        this.ensureAssociationModifiableElseThrowException(session, targetAdapter, (NakedObjectAssociation)association);
        String encodedObject = encodeableObjectData.getEncodedObjectData();
        NakedObjectSpecification specification = association.getSpecification();
        NakedObject adapter = this.restoreLeafObject(encodedObject, specification);
        association.setAssociation(targetAdapter, adapter);
        return new SetValueResponse(this.getUpdates());
    }

    public ClearAssociationResponse clearAssociation(ClearAssociationRequest request) {
        AuthenticationSession session = request.getSession();
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData targetData = request.getTarget();
        IdentityData associateData = request.getAssociate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request clearAssociation " + fieldIdentifier + " on " + targetData + " of " + associateData + " for " + session));
        }
        NakedObject targetAdapter = this.getPersistentNakedObject(session, targetData);
        NakedObject associateAdapter = this.getPersistentNakedObject(session, associateData);
        NakedObjectSpecification specification = targetAdapter.getSpecification();
        NakedObjectAssociation association = specification.getAssociation(fieldIdentifier);
        if (!association.isVisible(session, targetAdapter).isAllowed() || association.isUsable(session, targetAdapter).isVetoed()) {
            throw new NakedObjectException("can't modify field as not visible or editable");
        }
        this.ensureAssociationModifiableElseThrowException(session, targetAdapter, association);
        if (association instanceof OneToOneAssociation) {
            ((OneToOneAssociation)association).clearAssociation(targetAdapter);
        } else {
            ((OneToManyAssociation)association).removeElement(targetAdapter, associateAdapter);
        }
        return new ClearAssociationResponse(this.getUpdates());
    }

    public ClearValueResponse clearValue(ClearValueRequest request) {
        AuthenticationSession session = request.getSession();
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData targetIdentityData = request.getTarget();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request clearValue " + fieldIdentifier + " on " + targetIdentityData + " for " + session));
        }
        NakedObject targetAdapter = this.getPersistentNakedObject(session, targetIdentityData);
        OneToOneAssociation association = (OneToOneAssociation)targetAdapter.getSpecification().getAssociation(fieldIdentifier);
        this.ensureAssociationModifiableElseThrowException(session, targetAdapter, (NakedObjectAssociation)association);
        association.clearAssociation(targetAdapter);
        return new ClearValueResponse(this.getUpdates());
    }

    private void ensureAssociationModifiableElseThrowException(AuthenticationSession session, NakedObject targetAdapter, NakedObjectAssociation association) {
        if (!association.isVisible(session, targetAdapter).isAllowed() || association.isUsable(session, targetAdapter).isVetoed()) {
            throw new NakedObjectException("can't modify field as not visible or editable");
        }
    }

    public ExecuteClientActionResponse executeClientAction(ExecuteClientActionRequest request) {
        AuthenticationSession session = request.getSession();
        ReferenceData[] data = request.getData();
        int[] types = request.getTypes();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("execute client action for " + session));
            LOG.debug((Object)"start transaction");
        }
        ServerFacadeImpl.getTransactionManager().startTransaction();
        try {
            KnownObjectsRequest knownObjects = new KnownObjectsRequest();
            NakedObject[] persistedObjects = new NakedObject[data.length];
            NakedObject[] disposedObjects = new NakedObject[data.length];
            NakedObject[] changedObjects = new NakedObject[data.length];
            block11: for (int i = 0; i < data.length; ++i) {
                switch (types[i]) {
                    case 1: {
                        NakedObject object;
                        persistedObjects[i] = object = this.encoderDecoder.decode(data[i], knownObjects);
                        if (!object.getOid().isTransient()) continue block11;
                        LOG.debug((Object)("  makePersistent " + data[i]));
                        ServerFacadeImpl.getPersistenceSession().makePersistent(object);
                        continue block11;
                    }
                    case 2: {
                        NakedObject obj = this.getPersistentNakedObject(data[i]);
                        obj.checkLock(data[i].getVersion());
                        NakedObject object = this.encoderDecoder.decode(data[i], knownObjects);
                        LOG.debug((Object)("  objectChanged " + data[i]));
                        ServerFacadeImpl.getPersistenceSession().objectChanged(object);
                        changedObjects[i] = object;
                        continue block11;
                    }
                    case 3: {
                        NakedObject inObject = this.getPersistentNakedObject(data[i]);
                        inObject.checkLock(data[i].getVersion());
                        LOG.debug((Object)("  destroyObject " + data[i] + " for " + session));
                        disposedObjects[i] = inObject;
                        ServerFacadeImpl.getPersistenceSession().destroyObject(inObject);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"  end transaction");
            }
            ServerFacadeImpl.getTransactionManager().endTransaction();
            ReferenceData[] madePersistent = new ReferenceData[data.length];
            Version[] changedVersion = new Version[data.length];
            block12: for (int i = 0; i < data.length; ++i) {
                switch (types[i]) {
                    case 1: {
                        madePersistent[i] = this.encoderDecoder.encodeIdentityData(persistedObjects[i]);
                        continue block12;
                    }
                    case 2: {
                        changedVersion[i] = changedObjects[i].getVersion();
                    }
                }
            }
            return this.encoderDecoder.encodeClientActionResult(madePersistent, changedVersion, this.getUpdates());
        }
        catch (RuntimeException e) {
            LOG.info((Object)"abort transaction", (Throwable)e);
            ServerFacadeImpl.getTransactionManager().abortTransaction();
            throw e;
        }
    }

    public ExecuteServerActionResponse executeServerAction(ExecuteServerActionRequest request) {
        NakedObject targetAdapter;
        AuthenticationSession session = request.getSession();
        NakedObjectActionType actionType = request.getActionType();
        String actionIdentifier = request.getActionIdentifier();
        ReferenceData targetData = request.getTarget();
        Data[] parameterData = request.getParameters();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request executeAction " + actionIdentifier + " on " + targetData + " for " + session));
        }
        KnownObjectsRequest knownObjects = new KnownObjectsRequest();
        if (targetData instanceof IdentityData) {
            targetAdapter = this.getPersistentNakedObject(session, (IdentityData)targetData);
        } else if (targetData instanceof ObjectData) {
            targetAdapter = this.encoderDecoder.decode(targetData, knownObjects);
        } else if (targetData == null) {
            targetAdapter = null;
        } else {
            throw new NakedObjectException();
        }
        NakedObjectAction action = targetAdapter.getSpecification().getObjectAction(actionType, actionIdentifier);
        NakedObject[] parameters = this.getParameters(session, parameterData, knownObjects);
        if (action == null) {
            throw new NakedObjectsRemoteException("Could not find method " + actionIdentifier);
        }
        NakedObject resultAdapter = action.execute(targetAdapter, parameters);
        ObjectData persistedTargetData = targetData == null ? null : (targetData instanceof ObjectData ? this.encoderDecoder.encodeMadePersistentGraph((ObjectData)targetData, targetAdapter) : null);
        ObjectData[] persistedParameterData = new ObjectData[parameterData.length];
        for (int i = 0; i < persistedParameterData.length; ++i) {
            if (!action.getParameters()[i].getSpecification().isObject() || !(parameterData[i] instanceof ObjectData)) continue;
            persistedParameterData[i] = this.encoderDecoder.encodeMadePersistentGraph((ObjectData)parameterData[i], parameters[i]);
        }
        List messages = ServerFacadeImpl.getMessageBroker().getMessages();
        List warnings = ServerFacadeImpl.getMessageBroker().getWarnings();
        return this.encoderDecoder.encodeServerActionResult(resultAdapter, this.getUpdates(), this.getDisposed(), persistedTargetData, persistedParameterData, messages.toArray(new String[0]), warnings.toArray(new String[0]));
    }

    private NakedObjectAction getActionMethod(String actionType, String actionIdentifier, Data[] parameterData, NakedObject adapter) {
        NakedObjectSpecification[] parameterSpecs = new NakedObjectSpecification[parameterData.length];
        for (int i = 0; i < parameterSpecs.length; ++i) {
            parameterSpecs[i] = this.getSpecification(parameterData[i].getType());
        }
        NakedObjectActionType type = NakedObjectActionImpl.getType((String)actionType);
        int pos = actionIdentifier.indexOf(35);
        String className = actionIdentifier.substring(0, pos);
        String methodName = actionIdentifier.substring(pos + 1);
        if (adapter == null) {
            throw new UnexpectedCallException("object not specified");
        }
        return adapter.getSpecification().getObjectAction(type, methodName, parameterSpecs);
    }

    private NakedObject[] getParameters(AuthenticationSession session, Data[] parameterData, KnownObjectsRequest knownObjects) {
        NakedObject[] parameters = new NakedObject[parameterData.length];
        for (int i = 0; i < parameters.length; ++i) {
            Data data = parameterData[i];
            if (data instanceof NullData) continue;
            if (data instanceof IdentityData) {
                parameters[i] = this.getPersistentNakedObject(session, (IdentityData)data);
                continue;
            }
            if (data instanceof ObjectData) {
                parameters[i] = this.encoderDecoder.decode(data, knownObjects);
                continue;
            }
            if (data instanceof EncodableObjectData) {
                NakedObject value;
                NakedObjectSpecification valueSpecification = ServerFacadeImpl.getSpecificationLoader().loadSpecification(data.getType());
                String valueData = ((EncodableObjectData)data).getEncodedObjectData();
                parameters[i] = value = this.restoreLeafObject(valueData, valueSpecification);
                continue;
            }
            throw new UnknownTypeException((Object)data);
        }
        return parameters;
    }

    private ReferenceData[] getDisposed() {
        ArrayList<IdentityData> list = new ArrayList<IdentityData>();
        for (NakedObject element : ServerFacadeImpl.getUpdateNotifier().getDisposedObjects()) {
            list.add(this.encoderDecoder.encodeIdentityData(element));
        }
        return list.toArray(new ReferenceData[list.size()]);
    }

    public GetObjectResponse getObject(GetObjectRequest request) {
        Oid oid = request.getOid();
        String specificationName = request.getSpecificationName();
        NakedObjectSpecification specification = this.getSpecification(specificationName);
        NakedObject adapter = ServerFacadeImpl.getPersistenceSession().loadObject(oid, specification);
        return new GetObjectResponse(this.encoderDecoder.encodeForUpdate(adapter));
    }

    public ResolveFieldResponse resolveField(ResolveFieldRequest request) {
        AuthenticationSession session = request.getSession();
        IdentityData targetData = request.getTarget();
        String fieldIdentifier = request.getFieldIdentifier();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request resolveField " + targetData + "/" + fieldIdentifier + " for " + session));
        }
        NakedObjectSpecification spec = this.getSpecification(targetData.getType());
        NakedObjectAssociation field = spec.getAssociation(fieldIdentifier);
        NakedObject targetAdapter = ServerFacadeImpl.getPersistenceSession().recreateAdapter(targetData.getOid(), spec);
        ServerFacadeImpl.getPersistenceSession().resolveField(targetAdapter, field);
        Data data = this.encoderDecoder.encodeForResolveField(targetAdapter, fieldIdentifier);
        return new ResolveFieldResponse(data);
    }

    public ResolveObjectResponse resolveImmediately(ResolveObjectRequest request) {
        AuthenticationSession session = request.getSession();
        IdentityData targetData = request.getTarget();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request resolveImmediately " + targetData + " for " + session));
        }
        NakedObjectSpecification spec = this.getSpecification(targetData.getType());
        NakedObject object = ServerFacadeImpl.getPersistenceSession().loadObject(targetData.getOid(), spec);
        if (object.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            ServerFacadeImpl.getPersistenceSession().resolveImmediately(object);
        }
        return new ResolveObjectResponse(this.encoderDecoder.encodeCompletePersistentGraph(object));
    }

    public FindInstancesResponse findInstances(FindInstancesRequest request) {
        AuthenticationSession session = request.getSession();
        PersistenceQueryData criteriaData = request.getCriteria();
        PersistenceQuery criteria = this.encoderDecoder.decodePersistenceQuery(criteriaData);
        LOG.debug((Object)("request findInstances " + criteria + " for " + session));
        NakedObject instances = ServerFacadeImpl.getPersistenceSession().findInstances(criteria);
        ObjectData[] instancesData = this.convertToNakedCollection(instances);
        return new FindInstancesResponse(instancesData);
    }

    public HasInstancesResponse hasInstances(HasInstancesRequest request) {
        AuthenticationSession session = request.getSession();
        String specificationName = request.getSpecificationName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request hasInstances of " + specificationName + " for " + session));
        }
        boolean hasInstances = ServerFacadeImpl.getPersistenceSession().hasInstances(this.getSpecification(specificationName));
        return new HasInstancesResponse(hasInstances);
    }

    private ObjectData[] convertToNakedCollection(NakedObject instances) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)instances);
        ObjectData[] data = new ObjectData[facet.size(instances)];
        Enumeration elements = facet.elements(instances);
        int i = 0;
        while (elements.hasMoreElements()) {
            NakedObject element = (NakedObject)elements.nextElement();
            data[i++] = this.encoderDecoder.encodeCompletePersistentGraph(element);
        }
        return data;
    }

    public OidForServiceResponse oidForService(OidForServiceRequest request) {
        String serviceId = request.getServiceId();
        NakedObject serviceAdapter = ServerFacadeImpl.getPersistenceSession().getService(serviceId);
        if (serviceAdapter == null) {
            throw new NakedObjectsRemoteException("Failed to find service " + serviceId);
        }
        return new OidForServiceResponse(this.encoderDecoder.encodeIdentityData(serviceAdapter));
    }

    private NakedObjectSpecification getSpecification(String fullName) {
        return ServerFacadeImpl.getSpecificationLoader().loadSpecification(fullName);
    }

    private NakedObject getPersistentNakedObject(AuthenticationSession session, IdentityData object) {
        NakedObject obj = this.getPersistentNakedObject(object);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get object " + object + " for " + session + " --> " + obj));
        }
        obj.checkLock(object.getVersion());
        return obj;
    }

    private NakedObject getPersistentNakedObject(ReferenceData object) {
        NakedObjectSpecification spec = this.getSpecification(object.getType());
        NakedObject obj = ServerFacadeImpl.getPersistenceSession().loadObject(object.getOid(), spec);
        Assert.assertNotNull((Object)obj);
        return obj;
    }

    private NakedObject restoreLeafObject(String encodedObject, NakedObjectSpecification specification) {
        EncodableFacet encoder = (EncodableFacet)specification.getFacet(EncodableFacet.class);
        if (encoder == null) {
            throw new NakedObjectException("No encoder for " + specification.getFullName());
        }
        NakedObject object = encoder.fromEncodedString(encodedObject);
        return object;
    }

    private ObjectData[] getUpdates() {
        ArrayList<ObjectData> list = new ArrayList<ObjectData>();
        for (NakedObject element : ServerFacadeImpl.getUpdateNotifier().getChangedObjects()) {
            list.add(this.encoderDecoder.encodeForUpdate(element));
        }
        return list.toArray(new ObjectData[list.size()]);
    }

    public void setEncoder(ObjectEncoderDecoder objectEncoder) {
        this.encoderDecoder = objectEncoder;
    }

    private static SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static NakedObjectTransactionManager getTransactionManager() {
        return ServerFacadeImpl.getPersistenceSession().getTransactionManager();
    }

    private static UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }

    private static MessageBroker getMessageBroker() {
        return NakedObjectsContext.getMessageBroker();
    }
}

