/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol.encoding;

import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataInputStreamExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputStreamExtended;
import org.nakedobjects.metamodel.commons.encoding.DebugDataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DebugDataOutputExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.protocol.MarshallerAbstract;
import org.nakedobjects.remoting.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingMarshaller
extends MarshallerAbstract {
    private static final Logger LOG = Logger.getLogger(EncodingMarshaller.class);
    private boolean debugging;
    private DataInputExtended input;
    private DataOutputExtended output;

    public EncodingMarshaller(NakedObjectConfiguration configuration, Transport transport) {
        super(configuration, transport);
    }

    @Override
    public void init() {
        super.init();
        this.debugging = this.getConfiguration().getBoolean("nakedobjects.protocol.debugging", false);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("debugging=" + this.debugging));
        }
    }

    @Override
    public void connect() throws IOException {
        super.connect();
        this.input = new DataInputStreamExtended(this.getTransport().getInputStream());
        this.output = new DataOutputStreamExtended(this.getTransport().getOutputStream());
        if (this.debugging) {
            this.input = new DebugDataInputExtended(this.input);
            this.output = new DebugDataOutputExtended(this.output);
        }
    }

    private void writeToOutput(Object object) throws IOException {
        if (object instanceof Encodable) {
            As.ENCODABLE.writeObject(this.output, object);
        } else {
            As.SERIALIZABLE.writeObject(this.output, object);
        }
        this.output.flush();
    }

    private <T> T readFromInput(Class<T> cls) throws IOException {
        As as = As.readFrom(this.input);
        return as.readObject(this.input, cls);
    }

    @Override
    public Object request(Request request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sending request " + request));
        }
        try {
            this.writeToOutput(request);
        }
        catch (SocketException e) {
            this.reconnect();
            this.writeToOutput(request);
        }
        Object object = this.readFromInput(Object.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("response received: " + object));
        }
        if (!this.isKeepAlive()) {
            this.disconnect();
        }
        return object;
    }

    @Override
    public Request readRequest() throws IOException {
        Request request = this.readFromInput(Request.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("request received: " + request));
        }
        return request;
    }

    @Override
    public void sendResponse(Object response) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send response: " + response));
        }
        this.writeToOutput(response);
    }

    @Override
    public void sendError(NakedObjectException exception) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send error: " + (Object)((Object)exception)));
        }
        this.writeToOutput((Object)exception);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum As {
        ENCODABLE(0){

            @Override
            public void writeObject(DataOutputExtended output, Object object) throws IOException {
                this.writeTo(output);
                output.writeEncodable(object);
            }

            @Override
            public <T> T readObject(DataInputExtended input, Class<T> cls) throws IOException {
                return (T)input.readEncodable(cls);
            }
        }
        ,
        SERIALIZABLE(1){

            @Override
            public void writeObject(DataOutputExtended output, Object object) throws IOException {
                this.writeTo(output);
                output.writeSerializable(object);
            }

            @Override
            public <T> T readObject(DataInputExtended input, Class<T> cls) throws IOException {
                return (T)input.readSerializable(cls);
            }
        };

        static Map<Integer, As> cache;
        private final int idx;

        private As(int idx) {
            this.idx = idx;
        }

        static As get(int idx) {
            return cache.get(idx);
        }

        public static As readFrom(DataInputExtended input) throws IOException {
            return As.get(input.readByte());
        }

        public void writeTo(DataOutputExtended output) throws IOException {
            output.writeByte(this.idx);
        }

        public abstract void writeObject(DataOutputExtended var1, Object var2) throws IOException;

        public abstract <T> T readObject(DataInputExtended var1, Class<T> var2) throws IOException;

        static {
            cache = new HashMap<Integer, As>();
            for (As as : As.values()) {
                cache.put(as.idx, as);
            }
        }
    }
}

