/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol.encoding.internal;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.remoting.NakedObjectsRemoteException;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.common.CollectionData;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.NullData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.exchange.KnownObjectsRequest;
import org.nakedobjects.remoting.protocol.encoding.internal.FieldOrderCache;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionHydrator;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class ObjectDeserializer {
    private static final Logger LOG = Logger.getLogger(ObjectDeserializer.class);
    private final FieldOrderCache fieldOrderCache;

    public ObjectDeserializer(FieldOrderCache fieldOrderCache) {
        this.fieldOrderCache = fieldOrderCache;
    }

    public NakedObject deserialize(Data data) {
        if (data instanceof CollectionData) {
            return this.deserializeCollection((CollectionData)data, new KnownObjectsRequest());
        }
        return this.deserializeObject(data, new KnownObjectsRequest());
    }

    public NakedObject deserialize(Data data, KnownObjectsRequest knownObjects) {
        if (data instanceof CollectionData) {
            return this.deserializeCollection((CollectionData)data, knownObjects);
        }
        return this.deserializeObject(data, knownObjects);
    }

    private NakedObject deserializeCollection(CollectionData data, KnownObjectsRequest knownObjects) {
        String collectionType = data.getType();
        NakedObjectSpecification collectionSpecification = this.getSpecificationLoader().loadSpecification(collectionType);
        NakedObject collection = this.getPersistenceSession().createInstance(collectionSpecification);
        if (data.getElements() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"restoring empty collection");
            }
            return collection;
        }
        ReferenceData[] elements = data.getElements();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("restoring collection " + elements.length + " elements"));
        }
        NakedObject[] initData = new NakedObject[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            NakedObject element = this.deserializeObject(elements[i], knownObjects);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restoring collection element :" + element));
            }
            initData[i] = element;
        }
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        facet.init(collection, initData);
        return collection;
    }

    private NakedObject deserializeObject(Data data, KnownObjectsRequest knownObjects) {
        if (data instanceof NullData) {
            return null;
        }
        if (data instanceof ObjectData) {
            ObjectData objectData = (ObjectData)data;
            return this.deserializeObjectFromObjectData(objectData, knownObjects);
        }
        if (data instanceof IdentityData) {
            IdentityData identityData = (IdentityData)data;
            return this.deserializeObjectFromIdentityData(identityData, knownObjects);
        }
        if (data instanceof EncodableObjectData) {
            EncodableObjectData encodableObjectData = (EncodableObjectData)data;
            return this.deserializeObjectFromEncodableObjectData(encodableObjectData);
        }
        throw new UnknownTypeException((Object)data);
    }

    private NakedObject deserializeObjectFromIdentityData(IdentityData data, KnownObjectsRequest knownObjects) {
        Oid oid = data.getOid();
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter == null) {
            NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(data.getType());
            adapter = this.getHydrator().recreateAdapter(oid, specification);
        }
        return adapter;
    }

    private NakedObject deserializeObjectFromObjectData(ObjectData data, KnownObjectsRequest knownObjects) {
        if (knownObjects.containsKey(data)) {
            return knownObjects.get(data);
        }
        Oid oid = data.getOid();
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter != null) {
            this.updateLoadedObject(adapter, data, knownObjects);
        } else {
            adapter = oid.isTransient() ? this.deserializeTransient(data, knownObjects) : this.deserializePersistentObject(data, oid, knownObjects);
        }
        return adapter;
    }

    private NakedObject deserializeTransient(ObjectData adapterData, KnownObjectsRequest knownObjects) {
        NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(adapterData.getType());
        NakedObject adapter = this.getHydrator().recreateAdapter(adapterData.getOid(), specification);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("restore transient object " + adapter));
        }
        knownObjects.put(adapter, adapterData);
        this.setUpFields(adapter, adapterData, knownObjects);
        return adapter;
    }

    private NakedObject deserializePersistentObject(ObjectData data, Oid oid, KnownObjectsRequest knownObjects) {
        NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(data.getType());
        NakedObject adapter = this.getHydrator().recreateAdapter(oid, specification);
        if (data.getFieldContent() != null) {
            ResolveState state;
            adapter.setOptimisticLock(data.getVersion());
            ResolveState resolveState = state = data.hasCompleteData() ? ResolveState.RESOLVING : ResolveState.RESOLVING_PART;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("restoring existing object (" + state.name() + ") " + adapter));
            }
            this.setupFields(adapter, data, state, knownObjects);
        }
        return adapter;
    }

    private NakedObject deserializeObjectFromEncodableObjectData(EncodableObjectData encodeableObjectData) {
        if (encodeableObjectData.getEncodedObjectData() == null) {
            return null;
        }
        NakedObjectSpecification spec = this.getSpecificationLoader().loadSpecification(encodeableObjectData.getType());
        EncodableFacet encoder = (EncodableFacet)spec.getFacet(EncodableFacet.class);
        NakedObject adapter = encoder.fromEncodedString(encodeableObjectData.getEncodedObjectData());
        return adapter;
    }

    private void updateLoadedObject(NakedObject adapter, ObjectData adapterData, KnownObjectsRequest knownObjects) {
        if (adapterData.getFieldContent() != null) {
            adapter.setOptimisticLock(adapterData.getVersion());
            ResolveState state = this.nextState(adapter.getResolveState(), adapterData.hasCompleteData());
            if (state != null) {
                LOG.debug((Object)("updating existing object (" + state.name() + ") " + adapter));
                this.setupFields(adapter, adapterData, state, knownObjects);
                this.getUpdateNotifier().addChangedObject(adapter);
            }
        } else if (adapterData.getVersion() == null || adapterData.getVersion().different(adapter.getVersion())) {
            // empty if block
        }
    }

    private void setUpCollectionField(NakedObject adapter, ObjectData parentData, NakedObjectAssociation field, CollectionData collectionContentData, KnownObjectsRequest knownObjects) {
        if (collectionContentData.hasAllElements()) {
            this.setUpCollectionFieldForEntireContents(adapter, field, collectionContentData, knownObjects);
        } else {
            this.setUpCollectionFieldForNoContents(parentData, adapter, field);
        }
    }

    private void setUpCollectionFieldForNoContents(ObjectData parentData, NakedObject adapter, NakedObjectAssociation field) {
        Version parentVersion;
        Version adapterVersion;
        NakedObject collection = field.get(adapter);
        if (collection.getResolveState() == ResolveState.GHOST) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No data for collection: " + field.getId()));
        }
        if ((adapterVersion = adapter.getVersion()).different(parentVersion = parentData.getVersion())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("clearing collection as versions differ: " + adapter.getVersion() + " " + parentData.getVersion()));
            }
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
            facet.init(collection, new NakedObject[0]);
            collection.changeState(ResolveState.GHOST);
        }
    }

    private void setUpCollectionFieldForEntireContents(NakedObject adapter, NakedObjectAssociation field, CollectionData collectionContentData, KnownObjectsRequest knownObjects) {
        int size = collectionContentData.getElements().length;
        NakedObject[] elements = new NakedObject[size];
        for (int j = 0; j < elements.length; ++j) {
            elements[j] = this.deserializeObject(collectionContentData.getElements()[j], knownObjects);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("adding element to " + field.getId() + ": " + elements[j]));
        }
        NakedObject col = field.get(adapter);
        ResolveState initialState = col.getResolveState();
        ResolveState state = this.nextState(initialState, collectionContentData.hasAllElements());
        if (state != null) {
            PersistorUtil.start((NakedObject)col, (ResolveState)state);
            NakedObject collection = ((OneToManyAssociation)field).get(adapter);
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
            facet.init(collection, elements);
            PersistorUtil.end((NakedObject)col);
        } else {
            LOG.warn((Object)("not initialising collection " + col + " due to current state " + initialState));
        }
    }

    private void setupFields(NakedObject adapter, ObjectData adapterData, ResolveState state, KnownObjectsRequest knownObjects) {
        if (adapter.getResolveState().isDeserializable(state)) {
            PersistorUtil.start((NakedObject)adapter, (ResolveState)state);
            this.setUpFields(adapter, adapterData, knownObjects);
            PersistorUtil.end((NakedObject)adapter);
        }
    }

    private void setUpFields(NakedObject adapter, ObjectData adapterData, KnownObjectsRequest knownObjects) {
        Data[] fieldContent = adapterData.getFieldContent();
        if (fieldContent != null && fieldContent.length > 0) {
            NakedObjectAssociation[] fields = this.fieldOrderCache.getFields(adapter.getSpecification());
            if (fields.length != fieldContent.length) {
                throw new NakedObjectsRemoteException("Data received for different number of fields; expected " + fields.length + ", but was " + fieldContent.length);
            }
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectAssociation field = fields[i];
                Data fieldData = fieldContent[i];
                if (fieldData == null || field.isDerived()) {
                    LOG.debug((Object)("no data for field " + field.getId()));
                    continue;
                }
                if (field.isOneToManyAssociation()) {
                    this.setUpCollectionField(adapter, adapterData, field, (CollectionData)fieldData, knownObjects);
                    continue;
                }
                if (field.getSpecification().isEncodeable()) {
                    this.setUpEncodedField(adapter, (OneToOneAssociation)field, fieldData);
                    continue;
                }
                this.setUpReferenceField(adapter, (OneToOneAssociation)field, fieldData, knownObjects);
            }
        }
    }

    private void setUpReferenceField(NakedObject adapter, OneToOneAssociation field, Data data, KnownObjectsRequest knownObjects) {
        NakedObject associate = this.deserializeObject(data, knownObjects);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setting association for field " + field.getId() + ": " + associate));
        }
        field.initAssociation(adapter, associate);
    }

    private void setUpEncodedField(NakedObject adapter, OneToOneAssociation field, Data data) {
        if (data instanceof NullData) {
            field.initAssociation(adapter, null);
        } else {
            String value = ((EncodableObjectData)data).getEncodedObjectData();
            EncodableFacet encoder = (EncodableFacet)field.getSpecification().getFacet(EncodableFacet.class);
            NakedObject valueAdapter = encoder.fromEncodedString(value);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("setting value for field " + field.getId() + ": " + valueAdapter));
            }
            field.initAssociation(adapter, valueAdapter);
        }
    }

    public void madePersistent(NakedObject adapter, ObjectData adapterData) {
        Data[] fieldData;
        if (adapterData == null) {
            return;
        }
        if (adapter.isTransient() && adapter.getSpecification().persistability() != Persistability.TRANSIENT) {
            this.getAdapterManager().getAdapterFor(adapterData.getOid());
            adapter.setOptimisticLock(adapterData.getVersion());
            adapter.changeState(ResolveState.RESOLVED);
        }
        if ((fieldData = adapterData.getFieldContent()) == null) {
            return;
        }
        NakedObjectAssociation[] fields = this.fieldOrderCache.getFields(adapter.getSpecification());
        for (int i = 0; i < fieldData.length; ++i) {
            if (fieldData[i] == null) continue;
            if (fields[i].isOneToOneAssociation()) {
                NakedObject field = ((OneToOneAssociation)fields[i]).get(adapter);
                ObjectData fieldContent = (ObjectData)adapterData.getFieldContent()[i];
                if (field == null) continue;
                this.madePersistent(field, fieldContent);
                continue;
            }
            if (!fields[i].isOneToManyAssociation()) continue;
            CollectionData collectionData = (CollectionData)adapterData.getFieldContent()[i];
            NakedObject collectionAdapter = fields[i].get(adapter);
            if (!collectionAdapter.isPersistent()) {
                collectionAdapter.changeState(ResolveState.RESOLVED);
            }
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collectionAdapter);
            Enumeration elements = facet.elements(collectionAdapter);
            for (int j = 0; j < collectionData.getElements().length; ++j) {
                NakedObject element = (NakedObject)elements.nextElement();
                if (!(collectionData.getElements()[j] instanceof ObjectData)) continue;
                ObjectData elementData = (ObjectData)collectionData.getElements()[j];
                this.madePersistent(element, elementData);
            }
        }
    }

    private ResolveState nextState(ResolveState initialState, boolean complete) {
        ResolveState state = null;
        if (initialState == ResolveState.RESOLVED) {
            state = ResolveState.UPDATING;
        } else if (initialState == ResolveState.GHOST || initialState == ResolveState.PART_RESOLVED) {
            state = complete ? ResolveState.RESOLVING : ResolveState.RESOLVING_PART;
        } else if (initialState == ResolveState.TRANSIENT) {
            state = ResolveState.SERIALIZING_TRANSIENT;
        }
        return state;
    }

    private SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    private PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }
}

