/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol.serialize;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.protocol.IllegalRequestException;
import org.nakedobjects.remoting.protocol.MarshallerAbstract;
import org.nakedobjects.remoting.transport.ConnectionException;
import org.nakedobjects.remoting.transport.Transport;

public class SerializingMarshaller
extends MarshallerAbstract {
    private static final Logger LOG = Logger.getLogger(SerializingMarshaller.class);
    private ObjectInputStream input;
    private ObjectOutputStream output;

    public SerializingMarshaller(NakedObjectConfiguration configuration, Transport transport) {
        super(configuration, transport);
    }

    public void connect() throws IOException {
        super.connect();
        this.input = new ObjectInputStream(this.getTransport().getInputStream());
        this.output = new ObjectOutputStream(this.getTransport().getOutputStream());
    }

    public Object request(Request request) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sending request" + request));
            }
            try {
                this.output.writeObject(request);
            }
            catch (SocketException e) {
                this.reconnect();
                this.output.writeObject(request);
            }
            this.output.flush();
            Object object = this.input.readObject();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("response received: " + object));
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionException("Failed request", e);
        }
    }

    public Request readRequest() throws IOException {
        try {
            Request request = (Request)this.input.readObject();
            return request;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalRequestException("unknown class received; closing connection: " + e.getMessage(), e);
        }
    }

    public void sendError(NakedObjectException exception) throws IOException {
        this.send((Object)exception);
    }

    public void sendResponse(Object response) throws IOException {
        this.send(response);
    }

    private void send(Object object) throws IOException {
        this.output.writeObject(object);
        this.output.flush();
    }
}

