/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.transport.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.transport.ConnectionException;
import org.nakedobjects.remoting.transport.ProfilingInputStream;
import org.nakedobjects.remoting.transport.ProfilingOutputStream;
import org.nakedobjects.remoting.transport.TransportAbstract;

public class SocketTransport
extends TransportAbstract {
    private static final Logger LOG = Logger.getLogger(SocketTransport.class);
    private Socket socket;
    private int port;
    private String host;
    private boolean profiling;
    private OutputStream outputStream;
    private InputStream inputStream;

    public SocketTransport(NakedObjectConfiguration configuration) {
        super(configuration);
    }

    public void init() {
        this.port = this.getConfiguration().getInteger("nakedobjects.transport.sockets.port", 9580);
        this.host = this.getConfiguration().getString("nakedobjects.transport.sockets.host", "localhost");
        this.profiling = this.getConfiguration().getBoolean("nakedobjects.transport.sockets.profiling", true);
        LOG.info((Object)("connections will be made to " + this.host + " " + this.port));
    }

    public void shutdown() {
    }

    protected boolean isProfiling() {
        return this.profiling;
    }

    public void connect() {
        if (this.socket != null) {
            return;
        }
        try {
            this.socket = new Socket(this.host, this.port);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            if (this.isProfiling()) {
                this.inputStream = new ProfilingInputStream(this.inputStream);
                this.outputStream = new ProfilingOutputStream(this.outputStream);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("connection established " + this.socket));
            }
        }
        catch (MalformedURLException e) {
            throw new ConnectionException("Connection failure", e);
        }
        catch (UnknownHostException e) {
            throw new ConnectionException("Connection failure", e);
        }
        catch (ConnectException e) {
            throw new ConnectionException("Failed to connect to " + this.host + "/" + this.port, e);
        }
        catch (IOException e) {
            throw new ConnectionException("Connection failure", e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                LOG.error((Object)"failed to close connection", (Throwable)e);
            }
        }
    }
}

