/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.webapp.auth.AuthenticationSessionLookupStrategy;
import org.nakedobjects.webapp.auth.AuthenticationSessionLookupStrategyDefault;

public class NakedObjectsSessionFilter
implements Filter {
    public static final String AUTHENTICATION_SESSION_LOOKUP_STRATEGY_KEY = "authenticationSessionLookupStrategy";
    public static final String AUTHENTICATION_SESSION_LOOKUP_STRATEGY_DEFAULT = AuthenticationSessionLookupStrategyDefault.class.getName();
    public static final String LOGON_PAGE_KEY = "logonPage";
    private AuthenticationSessionLookupStrategy authSessionLookupStrategy;
    private String redirectResourceIfNoSession;

    public void init(FilterConfig config) throws ServletException {
        this.lookupAuthenticationSessionLookupStrategy(config);
        this.lookupRedirectIfNoSessionKey(config);
    }

    private void lookupAuthenticationSessionLookupStrategy(FilterConfig config) {
        String authLookupStrategyClassName = config.getInitParameter(AUTHENTICATION_SESSION_LOOKUP_STRATEGY_KEY);
        if (authLookupStrategyClassName == null) {
            authLookupStrategyClassName = AUTHENTICATION_SESSION_LOOKUP_STRATEGY_DEFAULT;
        }
        this.authSessionLookupStrategy = (AuthenticationSessionLookupStrategy)InstanceFactory.createInstance((String)authLookupStrategyClassName);
    }

    private void lookupRedirectIfNoSessionKey(FilterConfig config) {
        this.redirectResourceIfNoSession = config.getInitParameter(LOGON_PAGE_KEY);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        AuthenticationSession authSession = this.authSessionLookupStrategy.lookup(request, response);
        if (!this.isValid(authSession)) {
            if (this.redirectResourceIfNoSession != null && !this.redirectResourceIfNoSession.equals(httpRequest.getServletPath())) {
                httpResponse.sendRedirect(this.redirectResourceIfNoSession);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            this.authSessionLookupStrategy.bind(request, response, authSession);
            NakedObjectsContext.openSession((AuthenticationSession)authSession);
            chain.doFilter(request, response);
            NakedObjectsContext.closeSession();
        }
    }

    private boolean isValid(AuthenticationSession authSession) {
        return authSession != null && NakedObjectsSessionFilter.getAuthenticationManager().isSessionValid(authSession);
    }

    private static AuthenticationManager getAuthenticationManager() {
        return NakedObjectsContext.getAuthenticationManager();
    }
}

