/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.webapp;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSource;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSourceContextLoaderClassPath;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.ConfigurationBuilderAbstract;
import org.nakedobjects.metamodel.config.ConfigurationPrimer;
import org.nakedobjects.metamodel.config.NotFoundPolicy;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.logging.NakedObjectsLoggingConfigurer;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.system.NakedObjectsSystemBootstrapper;
import org.nakedobjects.webapp.ResourceStreamSourceServletContext;
import org.nakedobjects.webapp.WebAppConstants;

public class NakedObjectsWebAppBootstrapper
implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger(NakedObjectsWebAppBootstrapper.class);

    public static NakedObjectsSystem getSystemBoundTo(ServletContext servletContext) {
        Object system = servletContext.getAttribute(WebAppConstants.NAKED_OBJECTS_SYSTEM_KEY);
        return (NakedObjectsSystem)system;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String webInfDir = servletContext.getRealPath("/WEB-INF");
        NakedObjectsLoggingConfigurer.configureLogging((String)webInfDir, (String[])new String[0]);
        ConfigurationBuilderAbstract configurationBuilder = new ConfigurationBuilderAbstract(new ResourceStreamSource[]{new ResourceStreamSourceServletContext(servletContext), new ResourceStreamSourceContextLoaderClassPath()});
        this.primeConfigurationBuilder((ConfigurationBuilder)configurationBuilder, servletContext);
        DeploymentType deploymentType = this.determineDeploymentType((ConfigurationBuilder)configurationBuilder, servletContext);
        this.addConfigurationResourcesForWebApps((ConfigurationBuilder)configurationBuilder);
        this.addConfigurationResourcesForDeploymentType((ConfigurationBuilder)configurationBuilder, deploymentType);
        InstallerLookup installerLookup = NakedObjectsSystemBootstrapper.createAndInitializeInstallerLookup((ConfigurationBuilder)configurationBuilder, this.getClass());
        NakedObjectsSystem system = this.bootstrapNakedObjects(installerLookup, deploymentType);
        servletContext.setAttribute(WebAppConstants.NAKED_OBJECTS_SYSTEM_KEY, (Object)system);
        LOG.info((Object)"server started");
    }

    private void primeConfigurationBuilder(ConfigurationBuilder configurationBuilder, ServletContext servletContext) {
        List configurationPrimers = (List)servletContext.getAttribute("nakedobjects.configurationPrimers");
        if (configurationPrimers == null) {
            return;
        }
        for (ConfigurationPrimer configurationPrimer : configurationPrimers) {
            configurationPrimer.primeConfigurationBuilder(configurationBuilder);
        }
    }

    private DeploymentType determineDeploymentType(ConfigurationBuilder configurationBuilder, ServletContext servletContext) {
        String deploymentTypeStr = configurationBuilder.getConfiguration().getString("nakedobjects.deploymentType");
        if (deploymentTypeStr == null) {
            deploymentTypeStr = servletContext.getInitParameter("deploymentType");
        }
        if (deploymentTypeStr == null) {
            deploymentTypeStr = servletContext.getInitParameter("nakedobjects.deploymentType");
        }
        if (deploymentTypeStr == null) {
            deploymentTypeStr = WebAppConstants.DEPLOYMENT_TYPE_DEFAULT;
        }
        return DeploymentType.lookup((String)deploymentTypeStr);
    }

    private void addConfigurationResourcesForDeploymentType(ConfigurationBuilder configurationLoader, DeploymentType deploymentType) {
        String type = deploymentType.name().toLowerCase();
        configurationLoader.addConfigurationResource(type + ".properties", NotFoundPolicy.CONTINUE);
    }

    private void addConfigurationResourcesForWebApps(ConfigurationBuilder configurationLoader) {
        for (String config : new String[]{"web.properties", "war.properties"}) {
            if (config == null) continue;
            configurationLoader.addConfigurationResource(config, NotFoundPolicy.CONTINUE);
        }
    }

    private NakedObjectsSystem bootstrapNakedObjects(InstallerLookup installerLookup, DeploymentType deploymentType) {
        NakedObjectsSystemBootstrapper bootstrapper = new NakedObjectsSystemBootstrapper(installerLookup);
        return bootstrapper.bootSystem(deploymentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent ev) {
        LOG.info((Object)"server shutting down");
        ServletContext servletContext = ev.getServletContext();
        try {
            NakedObjectsSystem system = (NakedObjectsSystem)servletContext.getAttribute(WebAppConstants.NAKED_OBJECTS_SYSTEM_KEY);
            if (system != null) {
                LOG.info((Object)"calling system shutdown");
                system.shutdown();
            }
        }
        finally {
            servletContext.removeAttribute(WebAppConstants.NAKED_OBJECTS_SYSTEM_KEY);
            LOG.info((Object)"server shut down");
        }
    }
}

