/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.webapp.auth;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.authentication.standard.fixture.AuthenticationRequestLogonFixture;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.webapp.WebAppConstants;
import org.nakedobjects.webapp.auth.AuthenticationSessionLookupStrategyAbstract;

public class AuthenticationSessionLookupStrategyDefault
extends AuthenticationSessionLookupStrategyAbstract {
    public AuthenticationSession lookup(ServletRequest servletRequest, ServletResponse servletResponse) {
        boolean loggedInUsingLogonFixture;
        boolean sessionValid;
        HttpSession httpSession = this.getHttpSession(servletRequest);
        AuthenticationSession authSession = (AuthenticationSession)httpSession.getAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        if (authSession != null && (sessionValid = AuthenticationSessionLookupStrategyDefault.getAuthenticationManager().isSessionValid(authSession))) {
            return authSession;
        }
        ServletContext servletContext = this.getServletContext(servletRequest);
        NakedObjectsSystem system = (NakedObjectsSystem)servletContext.getAttribute(WebAppConstants.NAKED_OBJECTS_SYSTEM_KEY);
        if (system == null) {
            return null;
        }
        LogonFixture logonFixture = system.getLogonFixture();
        if (system.getDeploymentType().isExploring() && (authSession = AuthenticationSessionLookupStrategyDefault.getAuthenticationManager().authenticate((AuthenticationRequest)new AuthenticationRequestExploration(logonFixture))) != null) {
            return authSession;
        }
        boolean bl = loggedInUsingLogonFixture = httpSession.getAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY) != null;
        if (logonFixture != null && !loggedInUsingLogonFixture) {
            httpSession.setAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY, (Object)true);
            return AuthenticationSessionLookupStrategyDefault.getAuthenticationManager().authenticate((AuthenticationRequest)new AuthenticationRequestLogonFixture(logonFixture));
        }
        return null;
    }

    public void bind(ServletRequest servletRequest, ServletResponse servletResponse, AuthenticationSession authSession) {
        HttpSession httpSession = this.getHttpSession(servletRequest);
        httpSession.setAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY, (Object)authSession);
    }

    private static AuthenticationManager getAuthenticationManager() {
        return NakedObjectsContext.getAuthenticationManager();
    }
}

