/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.example.expenses.services.hibernate;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.nakedobjects.applib.annotation.Hidden;
import org.nakedobjects.example.expenses.claims.Claim;
import org.nakedobjects.example.expenses.claims.ClaimRepositoryAbstract;
import org.nakedobjects.example.expenses.claims.ClaimStatus;
import org.nakedobjects.example.expenses.claims.ExpenseItem;
import org.nakedobjects.example.expenses.claims.ExpenseType;
import org.nakedobjects.example.expenses.claims.items.AbstractExpenseItem;
import org.nakedobjects.example.expenses.employee.Employee;
import org.nakedobjects.example.expenses.services.hibernate.HibernateHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimRepositoryHibernate
extends ClaimRepositoryAbstract {
    private HibernateHelper hibernateHelper;
    static final String TEMPLATE_DESCRIPTION = "Template";
    private Integer maxClaimsToRetrieve;

    protected HibernateHelper getHibernateHelper() {
        return this.hibernateHelper;
    }

    public void setHibernateHelper(HibernateHelper hibernateHelper) {
        this.hibernateHelper = hibernateHelper;
    }

    private List<Claim> findAllClaims(Employee employee, ClaimStatus status, String description) {
        Criteria criteria = this.hibernateHelper.createCriteria(Claim.class);
        if (employee != null) {
            criteria.add((Criterion)Restrictions.eq((String)"claimant", (Object)employee));
        }
        if (status != null) {
            criteria.add((Criterion)Restrictions.eq((String)"status", (Object)status));
        }
        if (description != null) {
            criteria.add((Criterion)Restrictions.like((String)"description", (String)description, (MatchMode)MatchMode.ANYWHERE));
        }
        if (this.maxClaimsToRetrieve != null) {
            criteria.setMaxResults(this.maxClaimsToRetrieve.intValue());
        }
        criteria.addOrder(Order.desc((String)"dateCreated"));
        return this.hibernateHelper.findByCriteria(criteria, Employee.class);
    }

    @Hidden
    public List<Claim> findClaims(Employee employee, ClaimStatus status, String description) {
        List<Claim> foundClaims = this.findAllClaims(employee, status, description);
        if (foundClaims.size() > 20) {
            this.warnUser("Too many claims found - refine search");
            return null;
        }
        if (foundClaims.size() == 0) {
            this.informUser("No claims found");
        }
        return foundClaims;
    }

    @Hidden
    public void setHibernateSession(Session session) {
    }

    @Hidden
    public List<Claim> findRecentClaims(Employee employee) {
        this.maxClaimsToRetrieve = 10;
        List<Claim> foundClaims = this.findClaims(employee, null, null);
        this.maxClaimsToRetrieve = null;
        return foundClaims;
    }

    @Hidden
    public List<Claim> findClaimsAwaitingApprovalBy(Employee approver) {
        Criteria criteria = this.hibernateHelper.createCriteria(Claim.class);
        criteria.add((Criterion)Restrictions.eq((String)"approver", (Object)approver)).createCriteria("status").add((Criterion)Restrictions.eq((String)"titleString", (Object)"Submitted For Approval"));
        return this.hibernateHelper.findByCriteria(criteria, Claim.class);
    }

    @Hidden
    public List<ExpenseItem> findExpenseItemsOfType(Employee employee, ExpenseType type) {
        Query query = this.hibernateHelper.createEntityQuery("o.expenseType = ? and o.claim.claimant = ?", AbstractExpenseItem.class);
        query.setEntity(0, (Object)type);
        query.setEntity(1, (Object)employee);
        return this.hibernateHelper.findByQuery(query, ExpenseItem.class);
    }
}

