/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.example.expenses.fixtures;

import java.sql.DatabaseMetaData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.nakedobjects.applib.fixtures.AbstractFixture;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nos.store.hibernate.HibernateUtil;
import org.nakedobjects.nos.store.hibernate.security.DatabaseAuthenticator;

public class UserFixture
extends AbstractFixture {
    private static final int PERMISSIONS = 0;
    private static final int USER_ROLE = 1;
    private static final int ROLE = 2;
    private static final int USER = 3;
    private static final int GET_ID = 4;
    private static final int INSERT_USER = 5;
    private static final int INSERT_ROLE = 6;
    private static final int INSERT_USER_ROLE = 7;
    private static final int INSERT_PERMISSION = 8;
    private static final String[] MYSQL_SQL = new String[]{"CREATE TABLE `permissions` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, `role` INTEGER UNSIGNED NOT NULL,`permission` VARCHAR(255) NOT NULL, `flags` INTEGER UNSIGNED, PRIMARY KEY (`id`)) ENGINE = InnoDB;", "CREATE TABLE `user_role` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, `user` INTEGER UNSIGNED NOT NULL,`role` INTEGER UNSIGNED NOT NULL, PRIMARY KEY (`id`)) ENGINE = InnoDB;", "CREATE TABLE `role` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, `rolename` VARCHAR(255) NOT NULL, PRIMARY KEY (`id`)) ENGINE = InnoDB;", "CREATE TABLE `expenses`.`user` (`id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, `username` VARCHAR(255) NOT NULL,`password` VARCHAR(255) NOT NULL, `emailupdates` TINYINT(1) NOT NULL, PRIMARY KEY (`id`)) ENGINE = InnoDB;", "SELECT `id` FROM `?` ORDER BY `id` DESC LIMIT 1", "INSERT INTO `user` VALUES (?, ?, ?, ?)", "INSERT INTO `role` VALUES (?, ?)", "INSERT INTO `user_role` VALUES (?, (SELECT `id` FROM `user` WHERE `username` = ?), (SELECT `id` FROM `role` WHERE `rolename` = ?))", "INSERT INTO `permissions` VALUES (?, (SELECT `id` FROM `role` WHERE `rolename` = ?), ?, ?)"};
    private static final String[] HSQLDB_SQL = new String[]{"CREATE TABLE permissions (id INTEGER  NOT NULL , role INTEGER  NOT NULL,permission VARCHAR(255) NOT NULL, flags INTEGER, PRIMARY KEY (id));", "CREATE TABLE user_role (id INTEGER  NOT NULL , user INTEGER  NOT NULL,role INTEGER  NOT NULL, PRIMARY KEY (id));", "CREATE TABLE role (id INTEGER  NOT NULL , rolename VARCHAR(255) NOT NULL, PRIMARY KEY (id)) ;", "CREATE TABLE user (id INTEGER  NOT NULL , username VARCHAR(255) NOT NULL,password VARCHAR(255) NOT NULL, emailupdates TINYINT, PRIMARY KEY (id));", "SELECT id FROM ? ORDER BY id DESC LIMIT 1", "INSERT INTO user VALUES (?, ?, ?, ?)", "INSERT INTO role VALUES (?, ?)", "INSERT INTO user_role VALUES (?, (SELECT id FROM user WHERE username = ?), (SELECT id FROM role WHERE rolename = ?))", "INSERT INTO permissions VALUES (?, (SELECT id FROM role WHERE rolename = ?), ?, ?)"};
    private static final String[] POSTGRESQL_SQL = new String[]{"CREATE TABLE \"permissions\" (\"id\" INTEGER  NOT NULL , \"role\" INTEGER  NOT NULL,\"permission\" VARCHAR(255) NOT NULL, \"flags\" INTEGER, PRIMARY KEY (\"id\"));", "CREATE TABLE \"user_role\" (\"id\" INTEGER  NOT NULL , \"user\" INTEGER  NOT NULL,\"role\" INTEGER  NOT NULL, PRIMARY KEY (\"id\"));", "CREATE TABLE \"role\" (\"id\" INTEGER  NOT NULL , \"rolename\" VARCHAR(255) NOT NULL, PRIMARY KEY (\"id\")) ;", "CREATE TABLE \"user\" (\"id\" INTEGER  NOT NULL , \"username\" VARCHAR(255) NOT NULL,\"password\" VARCHAR(255) NOT NULL, \"emailupdates\" BOOLEAN, PRIMARY KEY (\"id\"));", "SELECT id FROM \"?\" ORDER BY id DESC LIMIT 1", "INSERT INTO \"user\" VALUES (?, ?, ?, ?)", "INSERT INTO \"role\" VALUES (?, ?)", "INSERT INTO \"user_role\" VALUES (?, (SELECT id FROM \"user\" WHERE username = ?), (SELECT id FROM \"role\" WHERE rolename = ?))", "INSERT INTO \"permissions\" VALUES (?, (SELECT id FROM \"role\" WHERE rolename = ?), ?, ?)"};
    private static final String[] SQL;

    private static String getDatabaseType() {
        try {
            HibernateUtil.startTransaction();
            DatabaseMetaData dbm = HibernateUtil.getCurrentSession().connection().getMetaData();
            HibernateUtil.commitTransaction();
            String dbURL = dbm.getURL();
            Pattern pattern = Pattern.compile("(.*jdbc\\:)([^\\:]*)(\\:.*)");
            Matcher matcher = pattern.matcher(dbURL);
            if (matcher.matches()) {
                return matcher.group(2);
            }
        }
        catch (Exception e) {
            throw new NakedObjectRuntimeException((Throwable)e);
        }
        return null;
    }

    private void createTable(String createSQL) {
        try {
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(createSQL);
            sq.executeUpdate();
            HibernateUtil.commitTransaction();
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
        }
    }

    private void createPermissionsTable() {
        String createTable = SQL[0];
        this.createTable(createTable);
    }

    private void createUserRoleTable() {
        String createTable = SQL[1];
        this.createTable(createTable);
    }

    private void createRoleTable() {
        String createTable = SQL[2];
        this.createTable(createTable);
    }

    private void createUserTable() {
        String createTable = SQL[3];
        this.createTable(createTable);
    }

    private int getNextId(String fromTable) {
        try {
            HibernateUtil.startTransaction();
            String tableSQL = SQL[4].replace("?", fromTable);
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(tableSQL);
            Integer id = (Integer)sq.uniqueResult();
            HibernateUtil.commitTransaction();
            return id != null ? id + 1 : 0;
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
            return 0;
        }
    }

    private void insertUser(String username, String password) {
        try {
            int nextId = this.getNextId("user");
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(SQL[5]);
            sq.setInteger(0, nextId);
            sq.setString(1, username);
            sq.setString(2, DatabaseAuthenticator.generateHash((String)password));
            sq.setBoolean(3, false);
            sq.executeUpdate();
            HibernateUtil.commitTransaction();
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
        }
    }

    private void insertRole(String role) {
        try {
            int nextId = this.getNextId("role");
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(SQL[6]);
            sq.setInteger(0, nextId);
            sq.setString(1, role);
            sq.executeUpdate();
            HibernateUtil.commitTransaction();
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
        }
    }

    private void insertUserRole(String user, String role) {
        try {
            int nextId = this.getNextId("user_role");
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(SQL[7]);
            sq.setInteger(0, nextId);
            sq.setString(1, user);
            sq.setString(2, role);
            sq.executeUpdate();
            HibernateUtil.commitTransaction();
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
        }
    }

    private void insertPermission(String role, String permission) {
        this.insertPermission(role, permission, null);
    }

    private void insertPermission(String role, String permission, Integer flag) {
        try {
            int nextId = this.getNextId("permissions");
            HibernateUtil.startTransaction();
            SQLQuery sq = HibernateUtil.getCurrentSession().createSQLQuery(SQL[8]);
            sq.setInteger(0, nextId);
            sq.setString(1, role);
            sq.setString(2, permission);
            if (flag == null) {
                sq.setParameter(3, null, (Type)Hibernate.INTEGER);
            } else {
                sq.setInteger(3, flag.intValue());
            }
            sq.executeUpdate();
            HibernateUtil.commitTransaction();
        }
        catch (Exception e) {
            HibernateUtil.rollbackTransaction();
        }
    }

    private void insertPermissions() {
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.employee.EmployeeStartPoints");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.employee.Employee");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#returnToClaimant(java.lang.String)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.recordedAction.impl.RecordedAction");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.employee.EmployeeStartPoints");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.employee.Employee");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#returnToClaimant(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.recordedAction.impl.RecordedAction");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.ClaimStartPoints#claimsAwaitingMyApproval()");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#approveItems(boolean)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#queryItems(java.lang.String,boolean)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#rejectItems(java.lang.String,boolean)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#approve()");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#query(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#reject(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#approve()");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#query(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#reject(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#approve()");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#query(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#reject(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#approve()");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#query(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#reject(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#approve()");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#query(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#reject(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#approve()");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#query(java.lang.String)");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#reject(java.lang.String)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.services.hibernate.EmployeeRepositoryHibernate");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.recordedAction.impl.RecordedActionContributedActions");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ClaimStartPoints#myRecentClaims()");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ClaimStartPoints#findMyClaims(org.nakedobjects.example.expenses.claims.ClaimStatus,java.lang.String)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ClaimStartPoints#createNewClaim(java.lang.String)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#createNewExpenseItem(org.nakedobjects.example.expenses.claims.ExpenseType)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#copyAnExistingExpenseItem(org.nakedobjects.example.expenses.claims.ExpenseItem)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#copyAllExpenseItemsFromAnotherClaim(org.nakedobjects.example.expenses.claims.Claim,org.nakedobjects.applib.value.Date)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#createNewClaimFromThis(java.lang.String,org.nakedobjects.applib.value.Date)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#submit(org.nakedobjects.example.expenses.employee.Employee,boolean)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#findSimilarExpenseItems()");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#copyFrom(org.nakedobjects.example.expenses.claims.ExpenseItem)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#findSimilarExpenseItems()");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#copyFrom(org.nakedobjects.example.expenses.claims.ExpenseItem)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#findSimilarExpenseItems()");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#copyFrom(org.nakedobjects.example.expenses.claims.ExpenseItem)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#findSimilarExpenseItems()");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#copyFrom(org.nakedobjects.example.expenses.claims.ExpenseItem)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#findSimilarExpenseItems()");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#copyFrom(org.nakedobjects.example.expenses.claims.ExpenseItem)");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.currency.Currency");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ProjectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#dateCreated");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#claimant");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#approver");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#total");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.Claim#expenseItems");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ExpenseItem#dateIncurred");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ExpenseItem#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ExpenseItem#amount");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ExpenseItem#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.ExpenseItem#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#dateIncurred");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#origin");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#destination");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#returnJourney");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#totalMiles");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#mileageRate");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#amount");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#comment");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#dateIncurred");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#amount");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#comment");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#dateIncurred");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#origin");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#destination");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#returnJourney");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#airlineAndFlight");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#amount");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#comment");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Airfare#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#dateIncurred");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#origin");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#destination");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#returnJourney");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#amount");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#comment");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Taxi#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#dateIncurred");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#hotelURL");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#numberOfNights");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#accommodation");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#food");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#other");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#amount");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.Hotel#comment");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#dateIncurred");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#description");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#amount");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#projectCode");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#status");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#comment");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#rentalCompany");
        this.insertPermission("claimant", "org.nakedobjects.example.expenses.claims.items.CarRental#numberOfDays");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.currency.Currency");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.ProjectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#dateCreated");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#approver");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#approver");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#total");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.Claim#expenseItems");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.ExpenseItem#dateIncurred");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.ExpenseItem#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.ExpenseItem#amount");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.ExpenseItem#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.ExpenseItem#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#dateIncurred");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#origin");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#destination");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#returnJourney");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#totalMiles");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#mileageRate");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#amount");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#comment");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.PrivateCarJourney#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#dateIncurred");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#amount");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.GeneralExpense#comment");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#dateIncurred");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#origin");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#destination");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#returnJourney");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#airlineAndFlight");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#amount");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#comment");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Airfare#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#dateIncurred");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#origin");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#destination");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#returnJourney");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#amount");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#comment");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Taxi#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#dateIncurred");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#hotelURL");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#numberOfNights");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#accommodation");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#food");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#other");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#amount");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.Hotel#comment");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#dateIncurred");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#description");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#amount");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#projectCode");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#status");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#comment");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#rentalCompany");
        this.insertPermission("approver", "org.nakedobjects.example.expenses.claims.items.CarRental#numberOfDays");
    }

    public void install() {
        this.createUserTable();
        this.createRoleTable();
        this.createUserRoleTable();
        this.createPermissionsTable();
        this.insertUser("sven", "pass");
        this.insertUser("dick", "pass");
        this.insertUser("bob", "pass");
        this.insertUser("joe", "pass");
        this.insertRole("claimant");
        this.insertRole("approver");
        this.insertUserRole("sven", "claimant");
        this.insertUserRole("dick", "claimant");
        this.insertUserRole("bob", "claimant");
        this.insertUserRole("joe", "claimant");
        this.insertUserRole("dick", "approver");
        this.insertPermissions();
    }

    static {
        String databaseType = UserFixture.getDatabaseType();
        SQL = "postgresql".equalsIgnoreCase(databaseType) ? POSTGRESQL_SQL : ("mysql".equalsIgnoreCase(databaseType) ? MYSQL_SQL : HSQLDB_SQL);
    }
}

