/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.webapp;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.security.ConnectionManager;
import org.nakedobjects.nof.boot.system.InstallerLookup;
import org.nakedobjects.nof.boot.system.NakedObjectsSystem;
import org.nakedobjects.nof.core.conf.DefaultConfigurationLoader;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.ThreadContext;
import org.nakedobjects.nof.core.security.AuthenticatorInstaller;
import org.nakedobjects.nof.core.service.ServicesFromConfiguration;
import org.nakedobjects.nof.core.system.ClientConnectionInstaller;
import org.nakedobjects.nof.core.system.ConfigurationLoader;
import org.nakedobjects.nof.core.system.FixturesInstaller;
import org.nakedobjects.nof.core.system.InstanceFactory;
import org.nakedobjects.nof.core.system.ObjectPersistorInstaller;
import org.nakedobjects.nof.core.system.ReflectorInstaller;
import org.nakedobjects.nof.core.system.ServerListenerInstaller;
import org.nakedobjects.nof.core.system.ServicesInstaller;
import org.nakedobjects.nof.core.system.TemplateImageLoaderInstaller;
import org.nakedobjects.nof.reflect.java.fixture.FixturesFromConfiguration;
import org.nakedobjects.nof.reflect.java.reflect.JavaReflectorInstaller;
import org.nakedobjects.nos.client.web.component.ImageLookup;
import org.nakedobjects.nos.client.web.servlet.SystemAccess;

public class ServletInitializer
implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger(ServletInitializer.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletInitializer instance = new ServletInitializer();
        instance.init(servletContextEvent.getServletContext());
    }

    private void init(ServletContext servletContext) {
        String dir = servletContext.getRealPath("/WEB-INF");
        NakedObjectsSystem system = new NakedObjectsSystem(dir);
        system.setServer(true);
        LOG.debug((Object)("current dir: " + new File(".").getAbsolutePath()));
        LOG.debug((Object)("real path: " + dir));
        DefaultConfigurationLoader configuration = new DefaultConfigurationLoader(dir);
        configuration.addConfigurationFile("web.properties", false);
        configuration.addConfigurationFile("war.properties", false);
        system.loadConfiguration((ConfigurationLoader)configuration);
        system.disableSplash(true);
        InstallerLookup installers = system.getInstallerFactory();
        installers.setConfiguration(configuration.load());
        ReflectorInstaller reflectorInstaller = (ReflectorInstaller)this.installer(servletContext, "reflector", JavaReflectorInstaller.class);
        configuration.addConfigurationFile(reflectorInstaller.getName() + ".properties", false);
        system.setReflectorInstaller(reflectorInstaller);
        ObjectPersistorInstaller persistorInstaller = installers.persistorInstaller(null, true);
        configuration.addConfigurationFile(persistorInstaller.getName() + ".properties", false);
        system.setObjectPersistorInstaller(persistorInstaller);
        ClientConnectionInstaller clientConnectionInstaller = installers.clientConnectionInstaller(null, null);
        if (clientConnectionInstaller != null) {
            configuration.addConfigurationFile(clientConnectionInstaller.getName() + ".properties", false);
            system.setClientConnection(clientConnectionInstaller);
        }
        system.setServicesInstaller((ServicesInstaller)this.installer(servletContext, "services", ServicesFromConfiguration.class));
        system.setFixtureInstaller((FixturesInstaller)this.installer(servletContext, "fixtures", FixturesFromConfiguration.class));
        system.setShareObjectsAcrossContexts(this.flag(servletContext, "share-objects-across-context", false));
        AuthenticatorInstaller authenticatorInstaller = installers.authenticatorInstaller(null);
        configuration.addConfigurationFile(authenticatorInstaller.getName() + ".properties", false);
        system.setAuthenticatorInstaller(authenticatorInstaller);
        String listenerInstaller = NakedObjectsContext.getConfiguration().getString("nakedobjects.component.listener");
        if (listenerInstaller != null) {
            ServerListenerInstaller installer = installers.listenerInstaller(listenerInstaller);
            system.addListener(installer);
        }
        system.setContext(ThreadContext.createInstance());
        system.setTemplateImageLoader((TemplateImageLoaderInstaller)new /* Unavailable Anonymous Inner Class!! */);
        system.init();
        ImageLookup.setImageDirectory((String)servletContext.getRealPath("/images"));
        new SystemAccess((ConnectionManager)system, system.getAuthenticationManager());
        LOG.info((Object)"server started");
        servletContext.setAttribute("System", (Object)system);
    }

    private boolean flag(ServletContext servletContext, String name, boolean defaultValue) {
        String param = servletContext.getInitParameter(name);
        boolean value = defaultValue;
        boolean defaultUsed = true;
        if (param != null) {
            value = param.equalsIgnoreCase("true");
            defaultUsed = false;
        }
        LOG.info((Object)(name + " flag " + value + (defaultUsed ? " (default)" : "")));
        return value;
    }

    private Object installer(ServletContext servletContext, String installerName, Class defaultClass) {
        String installerClass = servletContext.getInitParameter(installerName);
        boolean defaultUsed = false;
        if (installerClass == null && defaultClass != null) {
            installerClass = defaultClass.getName();
            defaultUsed = true;
        }
        if (installerClass == null) {
            LOG.info((Object)("No " + installerName + " installer class specified"));
            return null;
        }
        Object installer = InstanceFactory.createInstance((String)installerClass);
        LOG.info((Object)(installerName + " installer " + installer + (defaultUsed ? " (default)" : "")));
        return installer;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        LOG.info((Object)"server shutting down");
        NakedObjectsSystem system = (NakedObjectsSystem)arg0.getServletContext().getAttribute("System");
        if (system != null) {
            LOG.info((Object)"calling system shutdown");
            system.shutdown();
        }
        arg0.getServletContext().removeAttribute("System");
    }
}

