package org.nakedobjects.metamodel.adapter.version;

import java.util.Date;

import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;


public class SerialNumberVersion extends VersionAbstract implements Encodable {
    private final long versionNumber;

    public SerialNumberVersion(final long number, final String user, final Date time) {
        super(user, time);
        versionNumber = number;
    }

    public SerialNumberVersion(final ByteDecoder decoder) {
        super(decoder.getString(), new Date(decoder.getLong()));
        versionNumber = decoder.getLong();
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add(user);
        encoder.add(time.getTime());
        encoder.add(versionNumber);
    }

    public boolean different(final Version version) {
        if (version instanceof SerialNumberVersion) {
            final SerialNumberVersion other = (SerialNumberVersion) version;
            return versionNumber != other.versionNumber;
        } else {
            return false;
        }
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        } else if (obj instanceof SerialNumberVersion) {
            return !different((SerialNumberVersion) obj);
        } else {
            return false;
        }
    }

    public long getSequence() {
        return versionNumber;
    }

    @Override
    public int hashCode() {
        return (int) (versionNumber ^ (versionNumber >>> 32));
    }

    @Override
    protected VersionAbstract next() {
        return new SerialNumberVersion(versionNumber + 1, null, null);
    }

    public String sequence() {
        return Long.toString(versionNumber, 16);
    }

    @Override
    public String toString() {
        return "SerialNumberVersion#" + versionNumber + " " + ToString.timestamp(time);
    }

}
// Copyright (c) Naked Objects Group Ltd.
