package org.nakedobjects.metamodel.commons.about;

import java.util.MissingResourceException;
import java.util.ResourceBundle;


public class AboutNakedObjects {
    private static String applicationCopyrightNotice;
    private static String applicationName;
    private static String applicationVersion;
    private static String frameworkName;
    private static String frameworkVersion;
    private static String logo;
    private static String frameworkCopyright;
    private static String frameworkCompileDate;

    static {
        try {
            final ResourceBundle bundle = ResourceBundle.getBundle("nof-version");
            logo = bundle.getString("framework.logo");
            frameworkVersion = bundle.getString("framework.version");
            frameworkName = bundle.getString("framework.name");
            frameworkCopyright = bundle.getString("framework.copyright");
            frameworkCompileDate = bundle.getString("framework.compile.date");
        } catch (final MissingResourceException ex) {
            logo = "splash-logo";
            frameworkVersion = "${project.version}-r${buildNumber}";
            frameworkName = "${project.parent.name}";
            frameworkCopyright = "Copyright (c) 2002~2008 Naked Objects Group";
        }

    }

    public static String getApplicationCopyrightNotice() {
        return applicationCopyrightNotice;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static String getFrameworkCopyrightNotice() {
        return select(frameworkCopyright, "Copyright Naked Objects Group");
    }

    public static String getFrameworkCompileDate() {
        return frameworkCompileDate;
    }

    public static String getFrameworkName() {
        return select(frameworkName, "Naked Objects Framework");
    }

    public static String getImageName() {
        return select(logo, "splash-logo");
    }

    public static String getFrameworkVersion() {
        return "Version " + select(frameworkVersion, "unreleased");
    }

    public static void main(final String[] args) {
        System.out.println(getFrameworkName() + ", " + getFrameworkVersion());
        System.out.println(getFrameworkCopyrightNotice());
    }

    private static String select(final String value, final String defaultValue) {
        return value == null || value.startsWith("${") ? defaultValue : value;
    }

    public static void setApplicationCopyrightNotice(final String applicationCopyrightNotice) {
        AboutNakedObjects.applicationCopyrightNotice = applicationCopyrightNotice;
    }

    public static void setApplicationName(final String applicationName) {
        AboutNakedObjects.applicationName = applicationName;
    }

    public static void setApplicationVersion(final String applicationVersion) {
        AboutNakedObjects.applicationVersion = applicationVersion;
    }

}
// Copyright (c) Naked Objects Group Ltd.
