package org.nakedobjects.metamodel.commons.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;


public final class ListUtils {
    private ListUtils() {}

    /**
     * Returns list1 with everything in list2, ignoring duplicates.
     */
    public static <T> List<T> combine(final List<T> list1, final List<T> list2) {
        for (final Iterator<T> iter = list2.iterator(); iter.hasNext();) {
            final T obj = iter.next();
            if (!(list1.contains(obj))) {
                list1.add(obj);
            }
        }
        return list1;
    }

    public static List<String> combine(final String[] array1, final String[] array2) {
        final List<String> prefixes = new ArrayList<String>();
        addNoDuplicates(array1, prefixes);
        addNoDuplicates(array2, prefixes);
        return prefixes;
    }

    private static void addNoDuplicates(final String[] array, final List<String> list) {
        for (int i = 0; i < array.length; i++) {
            if (!list.contains(array[i])) {
                list.add(array[i]);
            }
        }
    }

    @SuppressWarnings("unchecked")
    public
    static List<Object> asList(final Object[] objectArray) {
        final List<Object> list = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; i++) {
            if (Collection.class.isAssignableFrom(objectArray[i].getClass())) {
                Collection collection = (Collection) objectArray[i];
                list.addAll(asList(collection.toArray()));
            } else {
                list.add(objectArray[i]);
            }
        }
        return list;
    }

}

// Copyright (c) Naked Objects Group Ltd.
