package org.nakedobjects.metamodel.config.provider;

import org.nakedobjects.metamodel.commons.component.Injectable;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;

public interface NakedObjectConfigurationProvider extends Injectable {

    NakedObjectConfiguration getConfiguration();

    /**
     * If supplied object is an instanceof {@link NakedObjectConfigurationProviderAware}, then
     * injects self into object; otherwise does nothing.
     * 
     * @return the supplied object.
     */
    public <T> T configure(T candidate);
}


// Copyright (c) Naked Objects Group Ltd.
