package org.nakedobjects.metamodel.config.reader.propfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.reader.ConfigurationReader;


public class PropertiesFileReader implements ConfigurationReader {
    private static final Logger LOG = Logger.getLogger(PropertiesFileReader.class);
    private final Properties properties;
    private boolean found = false;

    public PropertiesFileReader(final String directory, final String fileName, final boolean ensureFileLoads) {
        properties = new Properties();
        final File file = new File(directory, fileName);
        try {
            FileInputStream in;
            in = new FileInputStream(file);
            properties.load(in);
            found = true;
            LOG.info("configuration file " + file.getPath() + " loaded");
        } catch (final FileNotFoundException e) {
            if (ensureFileLoads) {
                throw new NakedObjectException("Could not find required configuration file: " + file.getPath());
            }
            LOG.info("configuration file " + file.getPath() + " not found, but not needed");
        } catch (final IOException e) {
            throw new NakedObjectException("Could not load configuration file " + file.getPath(), e);
        }
    }

    public Properties getProperties() {
        return properties;
    }

    public boolean isFound() {
        return found;
    }

}
// Copyright (c) Naked Objects Group Ltd.
