package org.nakedobjects.metamodel.criteria;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;


/**
 * Defines a criteria for including instances in set.
 */
public interface InstancesCriteria {

    /**
     * Returns true if the specified object is to be included in the set of instances.
     */
    boolean matches(NakedObject object);

    /**
     * The type of instances in the resulting set.
     */
    NakedObjectSpecification getSpecification();
}
// Copyright (c) Naked Objects Group Ltd.
