package org.nakedobjects.metamodel.criteria;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;


public class InstancesCriteriaTitle extends InstancesCriteriaAbstract {
    private final String requiredTitle;

    public InstancesCriteriaTitle(final NakedObjectSpecification specification, final String title) {
        super(specification);
        this.requiredTitle = title == null ? "" : title.toLowerCase();
    }

    public String getRequiredTitle() {
        return requiredTitle;
    }

    public boolean matches(final NakedObject object) {
        final String titleString = object.titleString();
        return matches(titleString);
    }

    public boolean matches(final String titleString) {
        final String objectTitle = titleString.toLowerCase();
        return objectTitle.indexOf(requiredTitle) >= 0;
    }

    @Override
    public String toString() {
        final ToString str = ToString.createAnonymous(this);
        str.append("spec", getSpecification().getShortName());
        str.append("title", requiredTitle);
        return str.toString();
    }

}
// Copyright (c) Naked Objects Group Ltd.
