package org.nakedobjects.metamodel.facets.actcoll.typeof;

import org.nakedobjects.metamodel.facets.SingleClassValueFacet;


/**
 * The type of the collection or the action.
 * 
 * <p>
 * In the standard Naked Objects Programming Model, corresponds to annotating the collection's accessor or the
 * action's invoker method with the <tt>@TypeOf</tt> annotation.
 */
public interface TypeOfFacet extends SingleClassValueFacet {

    /**
     * Does <b>not</b> correspond to a member in the <tt>@TypeOf</tt> annotation (or equiv), but indicates
     * that the information provided has been inferred rather than explicitly specified.
     */
    public boolean isInferred();
}
