package org.nakedobjects.metamodel.facets.actcoll.typeof;

import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.SingleClassValueFacetAbstract;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;


public abstract class TypeOfFacetAbstract extends SingleClassValueFacetAbstract implements TypeOfFacet {

    public static Class<? extends Facet> type() {
        return TypeOfFacet.class;
    }

    private final boolean inferred;

    public TypeOfFacetAbstract(
            final Class<?> value,
            final boolean inferred,
            final FacetHolder holder,
            final SpecificationLoader specificationLoader) {
        super(type(), holder, value, specificationLoader);
        this.inferred = inferred;
    }

    /**
     * Does <b>not</b> correspond to a member in the <tt>@TypeOf</tt> annotation (or equiv), but indicates
     * that the information provided has been inferred rather than explicitly specified.
     */
    public boolean isInferred() {
        return inferred;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + " [value=" + value() + ",inferred=" + inferred + "]";
    }
}
