package org.nakedobjects.metamodel.java5;

import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.Facet;


public final class ImperativeFacetUtils {

    private ImperativeFacetUtils() {}

    /**
     * Returns the provided {@link Facet facet} as an {@link ImperativeFacet} if it either is one or if it is
     * a {@link DecoratingFacet} that in turn wraps an {@link ImperativeFacet}.
     * 
     * <p>
     * Otherwise, returns <tt>null</tt>.
     */
    public static ImperativeFacet getImperativeFacet(final Facet facet) {
        if (facet instanceof ImperativeFacet) {
            return (ImperativeFacet) facet;
        }
        if (facet instanceof DecoratingFacet) {
            final DecoratingFacet<?> decoratingFacet = CastUtils.cast(facet);
            return getImperativeFacet(decoratingFacet.getDecoratedFacet());
        }
        return null;

    }

    public static boolean isImperativeFacet(final Facet facet) {
        return getImperativeFacet(facet) != null;
    }

}
