package org.nakedobjects.metamodel.spec;

import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorSet;


/**
 * Introduced to remove special-case processing for {@link PrimitiveSpecification}s that are not
 * introspectable.
 */
public interface IntrospectableSpecification extends NakedObjectSpecification {

    /**
     * Discovers what attributes and behaviour the type specified by this specification. As specification are
     * cyclic (specifically a class will reference its subclasses, which in turn reference their superclass)
     * they need be created first, and then later work out its internals. This allows for cyclic references to
     * the be accommodated as there should always a specification available even though it might not be
     * complete.
     */
    public abstract void introspect(FacetDecoratorSet decorator);

    public void markAsService();
}

// Copyright (c) Naked Objects Group Ltd.
