package org.nakedobjects.metamodel.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.DoubleFloatingPointValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;


public abstract class DoubleValueSemanticsProviderAbstract extends ValueSemanticsProviderAbstract implements
        DoubleFloatingPointValueFacet {

    private static Class<? extends Facet> type() {
        return DoubleFloatingPointValueFacet.class;
    }

    private static final int TYPICAL_LENGTH = 22;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;

    private final NumberFormat format;

    public DoubleValueSemanticsProviderAbstract(
    		final FacetHolder holder, final Class<?> adaptedClass, final Object defaultValue,
            final NakedObjectConfiguration configuration, 
            final SpecificationLoader specificationLoader, 
            final RuntimeContext runtimeContext) {
        super(type(), holder, adaptedClass, TYPICAL_LENGTH, IMMUTABLE, EQUAL_BY_CONTENT, defaultValue, configuration, specificationLoader, runtimeContext);
        format = determineNumberFormat("value.format.double");
    }

    // //////////////////////////////////////////////////////////////////
    // Parser
    // //////////////////////////////////////////////////////////////////

    @Override
    protected Object doParse(final Object original, final String entry) {
        try {
            return new Double(format.parse(entry).doubleValue());
        } catch (final ParseException e) {
            throw new TextEntryParseException("Not floating point number " + entry, e);
        }
    }

    // ///////////////////////////////////////////////////////////////////////////
    // TitleProvider
    // ///////////////////////////////////////////////////////////////////////////

    @Override
    public String titleString(final Object value) {
        return titleString(format, value);
    }

    public String titleWithMask(final String mask, final Object value) {
        return titleString(new DecimalFormat(mask), value);
    }

    // //////////////////////////////////////////////////////////////////
    // EncoderDecoder
    // //////////////////////////////////////////////////////////////////

    @Override
    protected String doEncode(final Object object) {
        return object.toString();
    }

    @Override
    protected Object doRestore(final String data) {
        return new Double(data);
    }

    // //////////////////////////////////////////////////////////////////
    // DoubleValueFacet
    // //////////////////////////////////////////////////////////////////

    public Double doubleValue(final NakedObject object) {
        return (Double) (object == null ? null : object.getObject());
    }

    public NakedObject createValue(final Double value) {
        return getRuntimeContext().adapterFor(value);
    }

    // /////// toString ///////
    @Override
    public String toString() {
        return "DoubleAdapter: " + format;
    }
    



}
// Copyright (c) Naked Objects Group Ltd.
