package org.nakedobjects.metamodel.value;

import org.nakedobjects.applib.value.Image;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;


public class ImageValueSemanticsProvider extends ImageValueSemanticsProviderAbstract {

    public ImageValueSemanticsProvider(final RuntimeContext runtimeContext) {
        super(runtimeContext);
    }

    public int getHeight(final NakedObject object) {
        return image(object).getHeight();
    }

    private Image image(final NakedObject object) {
        return (Image) object.getObject();
    }

    public java.awt.Image getImage(final NakedObject object) {
        return createImage(image(object).getImage());
    }

    @Override
    protected int[][] getPixels(final NakedObject object) {
        return image(object).getImage();
    }

    public Class<?> getValueClass() {
        return Image.class;
    }

    public int getWidth(final NakedObject object) {
        return image(object).getWidth();
    }

    public NakedObject setImage(final NakedObject object, final java.awt.Image image) {
        return getRuntimeContext().adapterFor(new Image(grabPixels(image)));
    }

    @Override
    protected Object setPixels(final int[][] pixels) {
        return new Image(pixels);
    }

    public Facet getUnderlyingFacet() {
        return null;
    }

    /**
     * Not required because {@link #alwaysReplace()} is <tt>false</tt>.
     */
    public void setUnderlyingFacet(Facet underlyingFacet) {
        throw new UnsupportedOperationException();
    }

    public boolean alwaysReplace() {
        return false;
    }

    public boolean isNoop() {
        return false;
    }

    @Override
    public String toString() {
        return "JavaAwtImageValueSemanticsProvider: ";
    }

}
// Copyright (c) Naked Objects Group Ltd.
