package org.nakedobjects.metamodel.value;

import java.awt.Image;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;


public class JavaAwtImageValueSemanticsProvider extends ImageValueSemanticsProviderAbstract {

    public JavaAwtImageValueSemanticsProvider(final RuntimeContext runtimeContext) {
		super(runtimeContext);
	}

	public int getHeight(final NakedObject object) {
        return image(object).getHeight(null);
    }

    private Image image(final NakedObject object) {
        return (Image) object.getObject();
    }

    public Image getImage(final NakedObject object) {
        return image(object);
    }

    @Override
    protected int[][] getPixels(final NakedObject object) {
        return grabPixels(image(object));
    }

    public Class<?> getValueClass() {
        return Image.class;
    }

    public int getWidth(final NakedObject object) {
        return image(object).getWidth(null);
    }

    @Override
    protected Object setPixels(final int[][] pixels) {
        final Image image = createImage(pixels);
        return getRuntimeContext().adapterFor(image);
    }


    public boolean isNoop() {
        return false;
    }

    @Override
    public String toString() {
        return "JavaAwtImageValueSemanticsProvider: ";
    }

    
}

// Copyright (c) Naked Objects Group Ltd.
