/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.encoding;

import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoderBuffer;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoderBuffer;
import org.nakedobjects.metamodel.commons.encoding.EncodableObject;
import org.nakedobjects.metamodel.commons.encoding.TestInputStream;
import org.nakedobjects.metamodel.commons.encoding.TestOutputStream;

public class ByteCoderTest
extends TestCase {
    private ByteEncoder encoder;
    private ByteDecoder decoder;

    protected void setUp() throws Exception {
        TestOutputStream out = new TestOutputStream();
        TestInputStream in = new TestInputStream(out.data);
        this.encoder = new ByteEncoderBuffer((OutputStream)out);
        this.decoder = new ByteDecoderBuffer((InputStream)in);
    }

    public void testStringEntry() {
        this.encoder.add("test");
        this.encoder.add("");
        this.encoder.add("second");
        ByteCoderTest.assertEquals((String)"test", (String)this.decoder.getString());
        ByteCoderTest.assertEquals((String)"", (String)this.decoder.getString());
        ByteCoderTest.assertEquals((String)"second", (String)this.decoder.getString());
    }

    public void testList() {
        String[] list = new String[]{"one", "two", "three"};
        this.encoder.add(list);
        String[] returnedList = this.decoder.getList();
        ByteCoderTest.assertEquals((int)list.length, (int)returnedList.length);
        ByteCoderTest.assertEquals((String)list[0], (String)returnedList[0]);
        ByteCoderTest.assertEquals((String)list[1], (String)returnedList[1]);
        ByteCoderTest.assertEquals((String)list[2], (String)returnedList[2]);
    }

    public void testLong() {
        this.encoder.add(245L);
        this.encoder.add(-456L);
        ByteCoderTest.assertEquals((long)245L, (long)this.decoder.getLong());
        ByteCoderTest.assertEquals((long)-456L, (long)this.decoder.getLong());
    }

    public void testBoolean() {
        this.encoder.add(true);
        this.encoder.add(false);
        ByteCoderTest.assertEquals((boolean)true, (boolean)this.decoder.getBoolean());
        ByteCoderTest.assertEquals((boolean)false, (boolean)this.decoder.getBoolean());
    }

    public void testObject() {
        this.encoder.add((Object)new EncodableObject());
        Object object = this.decoder.getObject();
        ByteCoderTest.assertTrue((boolean)(object instanceof EncodableObject));
        ByteCoderTest.assertEquals((String)"test field", (String)((EncodableObject)object).field);
    }

    public void testNull() {
        this.encoder.add((Object)null);
        Object object = this.decoder.getObject();
        ByteCoderTest.assertEquals(null, (Object)object);
    }

    public void testObjects() {
        Object[] array = new EncodableObject[]{new EncodableObject(), new EncodableObject(), new EncodableObject()};
        this.encoder.add(array);
        Object[] objects = this.decoder.getObjects();
        ByteCoderTest.assertTrue((boolean)(objects instanceof EncodableObject[]));
        ByteCoderTest.assertEquals((int)3, (int)objects.length);
        ByteCoderTest.assertEquals((String)"test field", (String)((EncodableObject)objects[2]).field);
    }

    public void testArrayAsObject() {
        EncodableObject[] array = new EncodableObject[]{new EncodableObject(), new EncodableObject(), new EncodableObject()};
        this.encoder.add((Object)array);
        Object objects = this.decoder.getObject();
        ByteCoderTest.assertTrue((boolean)(objects instanceof EncodableObject[]));
    }
}

